/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.optimizing;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.amoro.ServerTableIdentifier;
import org.apache.amoro.api.BlockableOperation;
import org.apache.amoro.resource.ResourceGroup;
import org.apache.amoro.server.optimizing.OptimizingStatus;
import org.apache.amoro.server.optimizing.sorter.SorterFactory;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulingPolicy {
    public static final Logger LOG = LoggerFactory.getLogger(SchedulingPolicy.class);
    private static final String SCHEDULING_POLICY_PROPERTY_NAME = "scheduling-policy";
    private final Map<ServerTableIdentifier, TableRuntime> tableRuntimeMap = new HashMap<ServerTableIdentifier, TableRuntime>();
    private volatile String policyName;
    private final Lock tableLock = new ReentrantLock();
    private static final Map<String, SorterFactory> sorterFactoryCache = new ConcurrentHashMap<String, SorterFactory>();

    public SchedulingPolicy(ResourceGroup group) {
        this.setTableSorterIfNeeded(group);
    }

    public void setTableSorterIfNeeded(ResourceGroup optimizerGroup) {
        this.tableLock.lock();
        try {
            this.policyName = Optional.ofNullable(optimizerGroup.getProperties()).orElseGet(Maps::newHashMap).getOrDefault(SCHEDULING_POLICY_PROPERTY_NAME, "quota");
        }
        finally {
            this.tableLock.unlock();
        }
    }

    public String name() {
        return this.policyName;
    }

    public TableRuntime scheduleTable(Set<ServerTableIdentifier> skipSet) {
        this.tableLock.lock();
        try {
            this.fillSkipSet(skipSet);
            TableRuntime tableRuntime2 = this.tableRuntimeMap.values().stream().filter(tableRuntime -> !skipSet.contains(tableRuntime.getTableIdentifier())).min(this.createSorterByPolicy()).orElse(null);
            return tableRuntime2;
        }
        finally {
            this.tableLock.unlock();
        }
    }

    private Comparator<TableRuntime> createSorterByPolicy() {
        if (sorterFactoryCache.get(this.policyName) != null) {
            SorterFactory sorterFactory = sorterFactoryCache.get(this.policyName);
            LOG.info("Using sorter instance {} corresponding to the scheduling policy {}", (Object)sorterFactory.getClass().getName(), (Object)this.policyName);
            return sorterFactory.createComparator();
        }
        throw new IllegalArgumentException("Unsupported scheduling policy: " + this.policyName);
    }

    public TableRuntime getTableRuntime(ServerTableIdentifier tableIdentifier) {
        this.tableLock.lock();
        try {
            TableRuntime tableRuntime = this.tableRuntimeMap.get(tableIdentifier);
            return tableRuntime;
        }
        finally {
            this.tableLock.unlock();
        }
    }

    private void fillSkipSet(Set<ServerTableIdentifier> originalSet) {
        long currentTime = System.currentTimeMillis();
        this.tableRuntimeMap.values().stream().filter(tableRuntime -> !this.isTablePending((TableRuntime)tableRuntime) || tableRuntime.isBlocked(BlockableOperation.OPTIMIZE) || currentTime - tableRuntime.getLastPlanTime() < tableRuntime.getOptimizingConfig().getMinPlanInterval()).forEach(tableRuntime -> originalSet.add(tableRuntime.getTableIdentifier()));
    }

    private boolean isTablePending(TableRuntime tableRuntime) {
        return tableRuntime.getOptimizingStatus() == OptimizingStatus.PENDING && (tableRuntime.getLastOptimizedSnapshotId() != tableRuntime.getCurrentSnapshotId() || tableRuntime.getLastOptimizedChangeSnapshotId() != tableRuntime.getCurrentChangeSnapshotId());
    }

    public void addTable(TableRuntime tableRuntime) {
        this.tableLock.lock();
        try {
            this.tableRuntimeMap.put(tableRuntime.getTableIdentifier(), tableRuntime);
        }
        finally {
            this.tableLock.unlock();
        }
    }

    public void removeTable(TableRuntime tableRuntime) {
        this.tableLock.lock();
        try {
            this.tableRuntimeMap.remove(tableRuntime.getTableIdentifier());
        }
        finally {
            this.tableLock.unlock();
        }
    }

    @VisibleForTesting
    Map<ServerTableIdentifier, TableRuntime> getTableRuntimeMap() {
        return this.tableRuntimeMap;
    }

    static {
        ServiceLoader<SorterFactory> sorterFactories = ServiceLoader.load(SorterFactory.class);
        Iterator<SorterFactory> iterator = sorterFactories.iterator();
        iterator.forEachRemaining(sorterFactory -> {
            String identifier = sorterFactory.getIdentifier();
            sorterFactoryCache.put(identifier, (SorterFactory)sorterFactory);
            LOG.info("Loaded scheduling policy {} and its corresponding sorter instance {}", (Object)identifier, (Object)sorterFactory.getClass().getName());
        });
    }
}

