/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.persistence.converter;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.LongTypeHandler;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;

@MappedJdbcTypes(value={JdbcType.TIMESTAMP})
@MappedTypes(value={long.class})
public class Long2TsConverter
extends LongTypeHandler {
    public void setNonNullParameter(PreparedStatement ps, int i, Long parameter, JdbcType jdbcType) throws SQLException {
        if (parameter == 0L) {
            ps.setTimestamp(i, null);
        } else {
            ps.setTimestamp(i, new Timestamp(parameter));
        }
    }

    public Long getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Timestamp ts = rs.getTimestamp(columnName);
        if (ts != null) {
            return ts.getTime();
        }
        return null;
    }

    public Long getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Timestamp ts = rs.getTimestamp(columnIndex);
        if (ts != null) {
            return ts.getTime();
        }
        return null;
    }

    public Long getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Timestamp ts = cs.getTimestamp(columnIndex);
        if (ts != null) {
            return ts.getTime();
        }
        return null;
    }
}

