/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.persistence.extension;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.scripting.xmltags.XMLLanguageDriver;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InListExtendedLanguageDriver
extends XMLLanguageDriver
implements LanguageDriver {
    private static final Logger LOG = LoggerFactory.getLogger(InListExtendedLanguageDriver.class);
    private final Pattern inNumberPattern = Pattern.compile("\\(#\\{(\\w+)::number\\[]}\\)");
    private final Pattern inStringPattern = Pattern.compile("\\(#\\{(\\w+)::string\\[]}\\)");

    public SqlSource createSqlSource(Configuration configuration, String script, Class<?> parameterType) {
        Matcher matcher = this.inNumberPattern.matcher(script);
        if (matcher.find()) {
            String newScript = this.inNumber(matcher);
            LOG.info("REPLACE IN_NUMBER_LIST original script:{}, new script:{}", (Object)script, (Object)newScript);
            return super.createSqlSource(configuration, newScript, parameterType);
        }
        matcher = this.inStringPattern.matcher(script);
        if (matcher.find()) {
            String newScript = this.inString(matcher);
            LOG.info("REPLACE IN_NUMBER_LIST original script:{}, new script:{}", (Object)script, (Object)newScript);
            return super.createSqlSource(configuration, newScript, parameterType);
        }
        return super.createSqlSource(configuration, script, parameterType);
    }

    private String inNumber(Matcher matcher) {
        String replacement = "(<foreach collection=\"$1\" item=\"__item\" separator=\",\" >#{__item}</foreach>)";
        String script = matcher.replaceAll("(<foreach collection=\"$1\" item=\"__item\" separator=\",\" >#{__item}</foreach>)");
        return "<script>" + script + "</script>";
    }

    private String inString(Matcher matcher) {
        String replacement = "(<foreach collection=\"$1\" item=\"__item\" separator=\",\" >\"#{__item}\"</foreach>)";
        String script = matcher.replaceAll("(<foreach collection=\"$1\" item=\"__item\" separator=\",\" >\"#{__item}\"</foreach>)");
        return "<script>" + script + "</script>";
    }
}

