/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.persistence.mapper;

import java.util.List;
import org.apache.amoro.server.persistence.converter.List2StringConverter;
import org.apache.amoro.server.persistence.converter.Long2TsConverter;
import org.apache.amoro.server.persistence.converter.Map2StringConverter;
import org.apache.amoro.server.table.blocker.TableBlocker;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Options;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

public interface TableBlockerMapper {
    public static final String TABLE_NAME = "table_blocker";

    @Select(value={"SELECT blocker_id,catalog_name,db_name,table_name,operations,create_time,expiration_time,properties FROM table_blocker WHERE catalog_name = #{catalog} AND db_name = #{database} AND table_name = #{tableName} AND expiration_time > #{now, typeHandler=org.apache.amoro.server.persistence.converter.Long2TsConverter}"})
    @Results(value={@Result(property="blockerId", column="blocker_id"), @Result(property="catalog", column="catalog_name"), @Result(property="database", column="db_name"), @Result(property="tableName", column="table_name"), @Result(property="operations", column="operations", typeHandler=List2StringConverter.class), @Result(property="createTime", column="create_time", typeHandler=Long2TsConverter.class), @Result(property="expirationTime", column="expiration_time", typeHandler=Long2TsConverter.class), @Result(property="properties", column="properties", typeHandler=Map2StringConverter.class)})
    public List<TableBlocker> selectBlockers(@Param(value="catalog") String var1, @Param(value="database") String var2, @Param(value="tableName") String var3, @Param(value="now") long var4);

    @Select(value={"SELECT blocker_id,catalog_name,db_name,table_name,operations,create_time,expiration_time,properties FROM table_blocker WHERE blocker_id = #{blockerId} AND expiration_time > #{now, typeHandler=org.apache.amoro.server.persistence.converter.Long2TsConverter}"})
    @Results(value={@Result(property="blockerId", column="blocker_id"), @Result(property="catalog", column="catalog_name"), @Result(property="database", column="db_name"), @Result(property="tableName", column="table_name"), @Result(property="operations", column="operations", typeHandler=List2StringConverter.class), @Result(property="createTime", column="create_time", typeHandler=Long2TsConverter.class), @Result(property="expirationTime", column="expiration_time", typeHandler=Long2TsConverter.class), @Result(property="properties", column="properties", typeHandler=Map2StringConverter.class)})
    public TableBlocker selectBlocker(@Param(value="blockerId") long var1, @Param(value="now") long var3);

    @Update(value={"UPDATE table_blocker SET expiration_time = #{expiration, typeHandler=org.apache.amoro.server.persistence.converter.Long2TsConverter} WHERE blocker_id = #{blockerId} AND expiration_time > #{now, typeHandler=org.apache.amoro.server.persistence.converter.Long2TsConverter}"})
    public int renewBlocker(@Param(value="blockerId") long var1, @Param(value="now") long var3, @Param(value="expiration") long var5);

    @Insert(value={"INSERT INTO table_blocker(catalog_name,db_name,table_name,operations,create_time,expiration_time,prev_blocker_id,properties) VALUES ( #{blocker.catalog},#{blocker.database},#{blocker.tableName},#{blocker.operations,typeHandler=org.apache.amoro.server.persistence.converter.List2StringConverter},#{blocker.createTime,typeHandler=org.apache.amoro.server.persistence.converter.Long2TsConverter},#{blocker.expirationTime,typeHandler=org.apache.amoro.server.persistence.converter.Long2TsConverter},#{blocker.prevBlockerId},#{blocker.properties,typeHandler=org.apache.amoro.server.persistence.converter.Map2StringConverter})"})
    @Options(useGeneratedKeys=true, keyProperty="blocker.blockerId")
    public int insert(@Param(value="blocker") TableBlocker var1);

    @Delete(value={"DELETE FROM table_blocker WHERE blocker_id = #{blockerId}"})
    public void deleteBlocker(@Param(value="blockerId") long var1);

    @Delete(value={"DELETE FROM table_blocker WHERE catalog_name = #{catalog} AND db_name = #{database} AND table_name = #{tableName} AND expiration_time <= #{now, typeHandler=org.apache.amoro.server.persistence.converter.Long2TsConverter}"})
    public int deleteExpiredBlockers(@Param(value="catalog") String var1, @Param(value="database") String var2, @Param(value="tableName") String var3, @Param(value="now") long var4);

    @Delete(value={"DELETE FROM table_blocker WHERE catalog_name = #{catalog} AND db_name = #{database} AND table_name = #{tableName}"})
    public int deleteTableBlockers(@Param(value="catalog") String var1, @Param(value="database") String var2, @Param(value="tableName") String var3);
}

