/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table.executor;

import org.apache.amoro.server.persistence.PersistentBase;
import org.apache.amoro.server.persistence.mapper.OptimizingMapper;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.server.table.TableService;
import org.apache.amoro.server.table.executor.BaseTableExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizingExpiringExecutor
extends BaseTableExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizingExpiringExecutor.class);
    private final Persistency persistency = new Persistency();
    private final long keepTime;
    private final long interval;

    public OptimizingExpiringExecutor(TableService tableService, int keepDays, int intervalHours) {
        super(tableService, 1);
        this.keepTime = (long)(keepDays * 24 * 60 * 60) * 1000L;
        this.interval = (long)(intervalHours * 60 * 60) * 1000L;
    }

    @Override
    protected long getNextExecutingTime(TableRuntime tableRuntime) {
        return this.interval;
    }

    @Override
    protected boolean enabled(TableRuntime tableRuntime) {
        return true;
    }

    @Override
    protected void execute(TableRuntime tableRuntime) {
        try {
            this.persistency.doExpiring(tableRuntime);
        }
        catch (Throwable throwable) {
            LOG.error("Expiring table runtimes of {} failed.", (Object)tableRuntime.getTableIdentifier(), (Object)throwable);
        }
    }

    private class Persistency
    extends PersistentBase {
        private Persistency() {
        }

        public void doExpiring(TableRuntime tableRuntime) {
            long expireTime = System.currentTimeMillis() - OptimizingExpiringExecutor.this.keepTime;
            this.doAsTransaction(() -> this.doAs(OptimizingMapper.class, mapper -> mapper.deleteOptimizingProcessBefore(tableRuntime.getTableIdentifier().getId(), expireTime)), () -> this.doAs(OptimizingMapper.class, mapper -> mapper.deleteTaskRuntimesBefore(tableRuntime.getTableIdentifier().getId(), expireTime)), () -> this.doAs(OptimizingMapper.class, mapper -> mapper.deleteOptimizingQuotaBefore(tableRuntime.getTableIdentifier().getId(), expireTime)));
        }
    }
}

