/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table.internal;

import java.util.HashMap;
import java.util.Map;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.server.table.TableMetadata;
import org.apache.amoro.server.table.internal.InternalIcebergCreator;
import org.apache.amoro.server.utils.InternalTableUtil;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.utils.TablePropertyUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.rest.requests.CreateTableRequest;

public class InternalMixedIcebergCreator
extends InternalIcebergCreator {
    private String changMetadataFileLocation;

    public InternalMixedIcebergCreator(CatalogMeta catalog, String database, String tableName, CreateTableRequest request) {
        super(catalog, database, tableName, request);
    }

    @Override
    protected TableFormat format() {
        return TableFormat.MIXED_ICEBERG;
    }

    @Override
    public TableMetadata create() {
        Map properties = this.request.properties();
        Preconditions.checkArgument((boolean)TablePropertyUtil.isBaseStore((Map)properties, (TableFormat)TableFormat.MIXED_ICEBERG), (Object)"The table creation request must be base store of mixed-iceberg");
        PrimaryKeySpec keySpec = TablePropertyUtil.parsePrimaryKeySpec((Schema)this.request.schema(), (Map)this.request.properties());
        if (keySpec.primaryKeyExisted()) {
            TableIdentifier identifier = TableIdentifier.of((String[])new String[]{this.database, this.tableName});
            TableIdentifier changeIdentifier = TablePropertyUtil.parseChangeIdentifier((Map)properties);
            String expectChangeStoreName = identifier.name() + "@change";
            TableIdentifier expectChangeIdentifier = TableIdentifier.of((Namespace)identifier.namespace(), (String)expectChangeStoreName);
            Preconditions.checkArgument((boolean)expectChangeIdentifier.equals((Object)changeIdentifier), (String)"the change store identifier is not expected. expected: %s, but found %s", (Object)expectChangeIdentifier.toString(), (Object)changeIdentifier.toString());
        }
        TableMetadata metadata = super.create();
        metadata.getProperties().put("mixed-iceberg.based-on-rest-catalog", Boolean.toString(true));
        if (!keySpec.primaryKeyExisted()) {
            return metadata;
        }
        HashMap changeProperties = Maps.newHashMap((Map)this.request.properties());
        changeProperties.putAll(TablePropertyUtil.changeStoreProperties((PrimaryKeySpec)keySpec, (TableFormat)TableFormat.MIXED_ICEBERG));
        String changeTableLocation = metadata.getTableLocation() + "/change";
        org.apache.iceberg.TableMetadata changeMetadata = org.apache.iceberg.TableMetadata.newTableMetadata((Schema)this.icebergMetadata.schema(), (PartitionSpec)this.icebergMetadata.spec(), (SortOrder)this.icebergMetadata.sortOrder(), (String)changeTableLocation, (Map)changeProperties);
        String changeMetadataFileLocation = InternalTableUtil.genNewMetadataFileLocation(null, changeMetadata);
        metadata.getProperties().put("change-store.iceberg.metadata.location", changeMetadataFileLocation);
        metadata.setChangeLocation(changeTableLocation);
        metadata.setPrimaryKey(keySpec.description());
        OutputFile changeStoreFile = this.io.newOutputFile(changeMetadataFileLocation);
        this.changMetadataFileLocation = changeMetadataFileLocation;
        TableMetadataParser.overwrite((org.apache.iceberg.TableMetadata)changeMetadata, (OutputFile)changeStoreFile);
        return metadata;
    }

    @Override
    public void rollback() {
        super.rollback();
        if (StringUtils.isNotEmpty((CharSequence)this.changMetadataFileLocation)) {
            this.io.deleteFile(this.changMetadataFileLocation);
        }
    }
}

