/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.utils;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.amoro.hive.table.SupportHive;
import org.apache.amoro.hive.utils.TableTypeUtil;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.utils.TableFileUtil;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;

public class HiveLocationUtil {
    public static Set<String> getHiveLocation(MixedTable table) {
        HashSet<String> hiveLocations = new HashSet<String>();
        if (TableTypeUtil.isHive((MixedTable)table)) {
            if (table.spec().isUnpartitioned()) {
                try {
                    Table hiveTable = (Table)((SupportHive)table).getHMSClient().run(client -> client.getTable(table.id().getDatabase(), table.id().getTableName()));
                    hiveLocations.add(TableFileUtil.getUriPath((String)hiveTable.getSd().getLocation()));
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to get hive table location", e);
                }
            }
            try {
                List partitions = (List)((SupportHive)table).getHMSClient().run(client -> client.listPartitions(table.id().getDatabase(), table.id().getTableName(), (short)Short.MAX_VALUE));
                for (Partition partition : partitions) {
                    hiveLocations.add(TableFileUtil.getUriPath((String)partition.getSd().getLocation()));
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to get hive partition locations", e);
            }
        }
        return hiveLocations;
    }
}

