/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.Function;
import org.apache.amoro.server.TableManagementService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftServiceProxy<S>
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TableManagementService.class);
    private final S service;
    private final Function<Throwable, Throwable> exceptionTransfer;

    private ThriftServiceProxy(S service, Function<Throwable, Throwable> exceptionTransfer) {
        this.service = service;
        this.exceptionTransfer = exceptionTransfer;
    }

    public static <S> S createProxy(Class<S> serviceClazz, S service, Function<Throwable, Throwable> exceptionTransfer) {
        return (S)Proxy.newProxyInstance(ThriftServiceProxy.class.getClassLoader(), new Class[]{serviceClazz}, new ThriftServiceProxy<S>(service, exceptionTransfer));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        try {
            result = method.invoke(this.service, args);
        }
        catch (InvocationTargetException e) {
            Throwable exception = e.getTargetException();
            String errorMessage = String.format("Thrift service:%s.%s execute failed", this.service.getClass().getSimpleName(), method.getName());
            LOG.error(errorMessage, exception);
            if (this.exceptionTransfer != null) {
                throw this.exceptionTransfer.apply(exception);
            }
            throw exception;
        }
        return result;
    }
}

