/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.Map;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.SparkUtil;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.Count;
import org.apache.spark.sql.connector.expressions.aggregate.CountStar;
import org.apache.spark.sql.connector.expressions.aggregate.Max;
import org.apache.spark.sql.connector.expressions.aggregate.Min;

public class SparkAggregates {
    private static final Map<Class<? extends AggregateFunc>, Expression.Operation> AGGREGATES = ImmutableMap.builder().put(Count.class, (Object)Expression.Operation.COUNT).put(CountStar.class, (Object)Expression.Operation.COUNT_STAR).put(Max.class, (Object)Expression.Operation.MAX).put(Min.class, (Object)Expression.Operation.MIN).buildOrThrow();

    private SparkAggregates() {
    }

    public static Expression convert(AggregateFunc aggregate) {
        Expression.Operation op = AGGREGATES.get(aggregate.getClass());
        if (op != null) {
            switch (op) {
                case COUNT: {
                    Count countAgg = (Count)aggregate;
                    if (countAgg.isDistinct()) {
                        return null;
                    }
                    if (countAgg.column() instanceof NamedReference) {
                        return Expressions.count((String)SparkUtil.toColumnName((NamedReference)countAgg.column()));
                    }
                    return null;
                }
                case COUNT_STAR: {
                    return Expressions.countStar();
                }
                case MAX: {
                    Max maxAgg = (Max)aggregate;
                    if (maxAgg.column() instanceof NamedReference) {
                        return Expressions.max((String)SparkUtil.toColumnName((NamedReference)maxAgg.column()));
                    }
                    return null;
                }
                case MIN: {
                    Min minAgg = (Min)aggregate;
                    if (minAgg.column() instanceof NamedReference) {
                        return Expressions.min((String)SparkUtil.toColumnName((NamedReference)minAgg.column()));
                    }
                    return null;
                }
            }
        }
        return null;
    }
}

