/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data.vectorized;

import org.apache.iceberg.arrow.vectorized.VectorHolder;
import org.apache.iceberg.spark.data.vectorized.ColumnVectorWithFilter;
import org.apache.iceberg.spark.data.vectorized.ConstantColumnVector;
import org.apache.iceberg.spark.data.vectorized.DeletedColumnVector;
import org.apache.iceberg.spark.data.vectorized.IcebergArrowColumnVector;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.vectorized.ColumnVector;

class ColumnVectorBuilder {
    private boolean[] isDeleted;
    private int[] rowIdMapping;

    ColumnVectorBuilder() {
    }

    public ColumnVectorBuilder withDeletedRows(int[] rowIdMappingArray, boolean[] isDeletedArray) {
        this.rowIdMapping = rowIdMappingArray;
        this.isDeleted = isDeletedArray;
        return this;
    }

    public ColumnVector build(VectorHolder holder, int numRows) {
        if (holder.isDummy()) {
            if (holder instanceof VectorHolder.DeletedVectorHolder) {
                return new DeletedColumnVector((Type)Types.BooleanType.get(), this.isDeleted);
            }
            if (holder instanceof VectorHolder.ConstantVectorHolder) {
                return new ConstantColumnVector((Type)Types.IntegerType.get(), numRows, ((VectorHolder.ConstantVectorHolder)holder).getConstant());
            }
            throw new IllegalStateException("Unknown dummy vector holder: " + holder);
        }
        if (this.rowIdMapping != null) {
            return new ColumnVectorWithFilter(holder, this.rowIdMapping);
        }
        return new IcebergArrowColumnVector(holder);
    }
}

