/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Map;
import org.apache.iceberg.DistributionMode;
import org.apache.iceberg.IsolationLevel;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.SparkDistributionAndOrderingUtil;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.SparkUtil;
import org.apache.iceberg.spark.SparkWriteConf;
import org.apache.iceberg.spark.source.SparkBatchQueryScan;
import org.apache.iceberg.spark.source.SparkPositionDeltaWrite;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.expressions.SortOrder;
import org.apache.spark.sql.connector.iceberg.write.DeltaWrite;
import org.apache.spark.sql.connector.iceberg.write.DeltaWriteBuilder;
import org.apache.spark.sql.connector.iceberg.write.ExtendedLogicalWriteInfo;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.write.RowLevelOperation;
import org.apache.spark.sql.types.StructType;

class SparkPositionDeltaWriteBuilder
implements DeltaWriteBuilder {
    private static final Schema EXPECTED_ROW_ID_SCHEMA = new Schema(new Types.NestedField[]{MetadataColumns.FILE_PATH, MetadataColumns.ROW_POSITION});
    private final SparkSession spark;
    private final Table table;
    private final RowLevelOperation.Command command;
    private final SparkBatchQueryScan scan;
    private final IsolationLevel isolationLevel;
    private final SparkWriteConf writeConf;
    private final ExtendedLogicalWriteInfo info;
    private final boolean handleTimestampWithoutZone;
    private final boolean checkNullability;
    private final boolean checkOrdering;

    SparkPositionDeltaWriteBuilder(SparkSession spark, Table table, String branch, RowLevelOperation.Command command, Scan scan, IsolationLevel isolationLevel, ExtendedLogicalWriteInfo info) {
        this.spark = spark;
        this.table = table;
        this.command = command;
        this.scan = (SparkBatchQueryScan)scan;
        this.isolationLevel = isolationLevel;
        this.writeConf = new SparkWriteConf(spark, table, branch, (Map<String, String>)info.options());
        this.info = info;
        this.handleTimestampWithoutZone = this.writeConf.handleTimestampWithoutZone();
        this.checkNullability = this.writeConf.checkNullability();
        this.checkOrdering = this.writeConf.checkOrdering();
    }

    @Override
    public DeltaWrite build() {
        Preconditions.checkArgument((this.handleTimestampWithoutZone || !SparkUtil.hasTimestampWithoutZone(this.table.schema()) ? 1 : 0) != 0, (Object)SparkUtil.TIMESTAMP_WITHOUT_TIMEZONE_ERROR);
        Schema dataSchema = this.dataSchema();
        if (dataSchema != null) {
            TypeUtil.validateWriteSchema((Schema)this.table.schema(), (Schema)dataSchema, (Boolean)this.checkNullability, (Boolean)this.checkOrdering);
        }
        Schema rowIdSchema = SparkSchemaUtil.convert(EXPECTED_ROW_ID_SCHEMA, this.info.rowIdSchema());
        TypeUtil.validateSchema((String)"row ID", (Schema)EXPECTED_ROW_ID_SCHEMA, (Schema)rowIdSchema, (boolean)this.checkNullability, (boolean)this.checkOrdering);
        Types.NestedField partition = MetadataColumns.metadataColumn((Table)this.table, (String)"_partition");
        Schema expectedMetadataSchema = new Schema(new Types.NestedField[]{MetadataColumns.SPEC_ID, partition});
        Schema metadataSchema = SparkSchemaUtil.convert(expectedMetadataSchema, this.info.metadataSchema());
        TypeUtil.validateSchema((String)"metadata", (Schema)expectedMetadataSchema, (Schema)metadataSchema, (boolean)this.checkNullability, (boolean)this.checkOrdering);
        SparkUtil.validatePartitionTransforms(this.table.spec());
        Distribution distribution = SparkDistributionAndOrderingUtil.buildPositionDeltaDistribution(this.table, this.command, this.distributionMode());
        SortOrder[] ordering = SparkDistributionAndOrderingUtil.buildPositionDeltaOrdering(this.table, this.command);
        return new SparkPositionDeltaWrite(this.spark, this.table, this.command, this.scan, this.isolationLevel, this.writeConf, this.info, dataSchema, distribution, ordering);
    }

    private Schema dataSchema() {
        StructType dataSparkType = this.info.schema();
        return dataSparkType != null ? SparkSchemaUtil.convert(this.table.schema(), dataSparkType) : null;
    }

    private DistributionMode distributionMode() {
        switch (this.command) {
            case DELETE: {
                return this.writeConf.deleteDistributionMode();
            }
            case UPDATE: {
                return this.writeConf.updateDistributionMode();
            }
            case MERGE: {
                return this.writeConf.positionDeltaMergeDistributionMode();
            }
        }
        throw new IllegalArgumentException("Unexpected command: " + this.command);
    }
}

