/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ByteBuffers;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

class StructInternalRow
extends InternalRow {
    private final Types.StructType type;
    private StructLike struct;

    StructInternalRow(Types.StructType type) {
        this.type = type;
    }

    private StructInternalRow(Types.StructType type, StructLike struct) {
        this.type = type;
        this.struct = struct;
    }

    public StructInternalRow setStruct(StructLike newStruct) {
        this.struct = newStruct;
        return this;
    }

    public int numFields() {
        return this.struct.size();
    }

    public void setNullAt(int i) {
        throw new UnsupportedOperationException("StructInternalRow is read-only");
    }

    public void update(int i, Object value) {
        throw new UnsupportedOperationException("StructInternalRow is read-only");
    }

    public InternalRow copy() {
        return this;
    }

    public boolean isNullAt(int ordinal) {
        return this.struct.get(ordinal, Object.class) == null;
    }

    public boolean getBoolean(int ordinal) {
        return (Boolean)this.struct.get(ordinal, Boolean.class);
    }

    public byte getByte(int ordinal) {
        return (byte)((Integer)this.struct.get(ordinal, Integer.class)).intValue();
    }

    public short getShort(int ordinal) {
        return (short)((Integer)this.struct.get(ordinal, Integer.class)).intValue();
    }

    public int getInt(int ordinal) {
        Object integer = this.struct.get(ordinal, Object.class);
        if (integer instanceof Integer) {
            return (Integer)integer;
        }
        if (integer instanceof LocalDate) {
            return (int)((LocalDate)integer).toEpochDay();
        }
        throw new IllegalStateException("Unknown type for int field. Type name: " + integer.getClass().getName());
    }

    public long getLong(int ordinal) {
        Object longVal = this.struct.get(ordinal, Object.class);
        if (longVal instanceof Long) {
            return (Long)longVal;
        }
        if (longVal instanceof OffsetDateTime) {
            return Duration.between(Instant.EPOCH, (OffsetDateTime)longVal).toNanos() / 1000L;
        }
        if (longVal instanceof LocalDate) {
            return ((LocalDate)longVal).toEpochDay();
        }
        throw new IllegalStateException("Unknown type for long field. Type name: " + longVal.getClass().getName());
    }

    public float getFloat(int ordinal) {
        return ((Float)this.struct.get(ordinal, Float.class)).floatValue();
    }

    public double getDouble(int ordinal) {
        return (Double)this.struct.get(ordinal, Double.class);
    }

    public Decimal getDecimal(int ordinal, int precision, int scale) {
        return this.isNullAt(ordinal) ? null : this.getDecimalInternal(ordinal, precision, scale);
    }

    private Decimal getDecimalInternal(int ordinal, int precision, int scale) {
        return Decimal.apply((BigDecimal)((BigDecimal)this.struct.get(ordinal, BigDecimal.class)));
    }

    public UTF8String getUTF8String(int ordinal) {
        return this.isNullAt(ordinal) ? null : this.getUTF8StringInternal(ordinal);
    }

    private UTF8String getUTF8StringInternal(int ordinal) {
        CharSequence seq = (CharSequence)this.struct.get(ordinal, CharSequence.class);
        return UTF8String.fromString((String)seq.toString());
    }

    public byte[] getBinary(int ordinal) {
        return this.isNullAt(ordinal) ? null : this.getBinaryInternal(ordinal);
    }

    private byte[] getBinaryInternal(int ordinal) {
        Object bytes = this.struct.get(ordinal, Object.class);
        if (bytes instanceof ByteBuffer) {
            return ByteBuffers.toByteArray((ByteBuffer)((ByteBuffer)bytes));
        }
        if (bytes instanceof byte[]) {
            return (byte[])bytes;
        }
        throw new IllegalStateException("Unknown type for binary field. Type name: " + bytes.getClass().getName());
    }

    public CalendarInterval getInterval(int ordinal) {
        throw new UnsupportedOperationException("Unsupported type: interval");
    }

    public InternalRow getStruct(int ordinal, int numFields) {
        return this.isNullAt(ordinal) ? null : this.getStructInternal(ordinal, numFields);
    }

    private InternalRow getStructInternal(int ordinal, int numFields) {
        return new StructInternalRow(((Types.NestedField)this.type.fields().get(ordinal)).type().asStructType(), (StructLike)this.struct.get(ordinal, StructLike.class));
    }

    public ArrayData getArray(int ordinal) {
        return this.isNullAt(ordinal) ? null : this.getArrayInternal(ordinal);
    }

    private ArrayData getArrayInternal(int ordinal) {
        return this.collectionToArrayData(((Types.NestedField)this.type.fields().get(ordinal)).type().asListType().elementType(), (Collection)this.struct.get(ordinal, Collection.class));
    }

    public MapData getMap(int ordinal) {
        return this.isNullAt(ordinal) ? null : this.getMapInternal(ordinal);
    }

    private MapData getMapInternal(int ordinal) {
        return this.mapToMapData(((Types.NestedField)this.type.fields().get(ordinal)).type().asMapType(), (Map)this.struct.get(ordinal, Map.class));
    }

    public Object get(int ordinal, DataType dataType) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        if (dataType instanceof IntegerType) {
            return this.getInt(ordinal);
        }
        if (dataType instanceof LongType) {
            return this.getLong(ordinal);
        }
        if (dataType instanceof StringType) {
            return this.getUTF8StringInternal(ordinal);
        }
        if (dataType instanceof FloatType) {
            return Float.valueOf(this.getFloat(ordinal));
        }
        if (dataType instanceof DoubleType) {
            return this.getDouble(ordinal);
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return this.getDecimalInternal(ordinal, decimalType.precision(), decimalType.scale());
        }
        if (dataType instanceof BinaryType) {
            return this.getBinaryInternal(ordinal);
        }
        if (dataType instanceof StructType) {
            return this.getStructInternal(ordinal, ((StructType)dataType).size());
        }
        if (dataType instanceof ArrayType) {
            return this.getArrayInternal(ordinal);
        }
        if (dataType instanceof MapType) {
            return this.getMapInternal(ordinal);
        }
        if (dataType instanceof BooleanType) {
            return this.getBoolean(ordinal);
        }
        if (dataType instanceof ByteType) {
            return this.getByte(ordinal);
        }
        if (dataType instanceof ShortType) {
            return this.getShort(ordinal);
        }
        if (dataType instanceof DateType) {
            return this.getInt(ordinal);
        }
        if (dataType instanceof TimestampType) {
            return this.getLong(ordinal);
        }
        return null;
    }

    private MapData mapToMapData(Types.MapType mapType, Map<?, ?> map) {
        ImmutableList entries = ImmutableList.copyOf(map.entrySet());
        return new ArrayBasedMapData(this.collectionToArrayData(mapType.keyType(), Lists.transform((List)entries, Map.Entry::getKey)), this.collectionToArrayData(mapType.valueType(), Lists.transform((List)entries, Map.Entry::getValue)));
    }

    private ArrayData collectionToArrayData(Type elementType, Collection<?> values) {
        switch (elementType.typeId()) {
            case BOOLEAN: 
            case INTEGER: 
            case DATE: 
            case TIME: 
            case LONG: 
            case TIMESTAMP: 
            case FLOAT: 
            case DOUBLE: {
                return this.fillArray(values, array -> (pos, value) -> {
                    array[pos.intValue()] = value;
                });
            }
            case STRING: {
                return this.fillArray(values, array -> (pos, seq) -> {
                    array[pos.intValue()] = UTF8String.fromString((String)seq.toString());
                });
            }
            case FIXED: 
            case BINARY: {
                return this.fillArray(values, array -> (pos, buf) -> {
                    array[pos.intValue()] = ByteBuffers.toByteArray((ByteBuffer)buf);
                });
            }
            case DECIMAL: {
                return this.fillArray(values, array -> (pos, dec) -> {
                    array[pos.intValue()] = Decimal.apply((BigDecimal)dec);
                });
            }
            case STRUCT: {
                return this.fillArray(values, array -> (pos, tuple) -> {
                    array[pos.intValue()] = new StructInternalRow(elementType.asStructType(), (StructLike)tuple);
                });
            }
            case LIST: {
                return this.fillArray(values, array -> (pos, list) -> {
                    array[pos.intValue()] = this.collectionToArrayData(elementType.asListType().elementType(), (Collection<?>)list);
                });
            }
            case MAP: {
                return this.fillArray(values, array -> (pos, map) -> {
                    array[pos.intValue()] = this.mapToMapData(elementType.asMapType(), (Map<?, ?>)map);
                });
            }
        }
        throw new UnsupportedOperationException("Unsupported array element type: " + elementType);
    }

    private <T> GenericArrayData fillArray(Collection<?> values, Function<Object[], BiConsumer<Integer, T>> makeSetter) {
        Object[] array = new Object[values.size()];
        BiConsumer<Integer, Integer> setter = makeSetter.apply(array);
        int index = 0;
        for (Object value : values) {
            if (value == null) {
                array[index] = null;
            } else {
                setter.accept(index, (Integer)value);
            }
            ++index;
        }
        return new GenericArrayData(array);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        StructInternalRow that = (StructInternalRow)((Object)other);
        return this.type.equals((Object)that.type) && this.struct.equals(that.struct);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.struct);
    }
}

