/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.client;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.amoro.client.AmsThriftUrl;
import org.apache.amoro.client.ConnectionFailException;
import org.apache.amoro.client.NoBackendServiceException;
import org.apache.amoro.client.PoolConfig;
import org.apache.amoro.client.ServiceInfo;
import org.apache.amoro.client.ThriftClient;
import org.apache.amoro.client.ThriftClientFactory;
import org.apache.amoro.client.ThriftException;
import org.apache.amoro.client.ThriftPingFactory;
import org.apache.amoro.shade.thrift.org.apache.thrift.TConfiguration;
import org.apache.amoro.shade.thrift.org.apache.thrift.TServiceClient;
import org.apache.amoro.shade.thrift.org.apache.thrift.transport.TSocket;
import org.apache.amoro.shade.thrift.org.apache.thrift.transport.TTransport;
import org.apache.amoro.shade.thrift.org.apache.thrift.transport.TTransportException;
import org.apache.amoro.shade.thrift.org.apache.thrift.transport.layered.TFramedTransport;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftClientPool<T extends TServiceClient> {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftClientPool.class);
    private static final int RECONNECT_INTERVAL = 2000;
    private static final int BORROW_ATTEMPTS = 5;
    private final ThriftClientFactory clientFactory;
    private final ThriftPingFactory pingFactory;
    private final GenericObjectPool<ThriftClient<T>> pool;
    private final PoolConfig<T> poolConfig;

    public ThriftClientPool(final String url, ThriftClientFactory factory, ThriftPingFactory pingFactory, PoolConfig<T> config, final String serviceName) {
        if (url == null || url.isEmpty()) {
            throw new IllegalArgumentException("url is empty!");
        }
        if (factory == null) {
            throw new IllegalArgumentException("factory is empty!");
        }
        if (config == null) {
            throw new IllegalArgumentException("config is empty!");
        }
        this.clientFactory = factory;
        this.pingFactory = pingFactory;
        this.poolConfig = config;
        this.poolConfig.setTestOnReturn(true);
        this.poolConfig.setTestOnBorrow(true);
        this.pool = new GenericObjectPool((PooledObjectFactory)new BasePooledObjectFactory<ThriftClient<T>>(){

            public ThriftClient<T> create() throws Exception {
                AmsThriftUrl amsThriftUrl = AmsThriftUrl.parse(url, serviceName);
                ServiceInfo serviceInfo = new ServiceInfo(amsThriftUrl.host(), amsThriftUrl.port());
                TTransport transport = ThriftClientPool.this.getTransport(serviceInfo);
                try {
                    transport.open();
                }
                catch (TTransportException e) {
                    LOG.warn("Transport open failed, service address: {}:{}", (Object)serviceInfo.getHost(), (Object)serviceInfo.getPort());
                    if (ThriftClientPool.this.poolConfig.isAutoReconnect() && ThriftClientPool.this.poolConfig.getMaxReconnects() > 0) {
                        for (int i = 0; i < ThriftClientPool.this.poolConfig.getMaxReconnects(); ++i) {
                            try {
                                amsThriftUrl = AmsThriftUrl.parse(url, serviceName);
                                serviceInfo.setHost(amsThriftUrl.host());
                                serviceInfo.setPort(amsThriftUrl.port());
                                transport = ThriftClientPool.this.getTransport(serviceInfo);
                                LOG.info("Reconnecting service address: {}:{}", (Object)serviceInfo.getHost(), (Object)serviceInfo.getPort());
                                transport.open();
                                break;
                            }
                            catch (TTransportException e2) {
                                LOG.warn("Reconnected service address: {}:{} failed", new Object[]{serviceInfo.getHost(), serviceInfo.getPort(), e2});
                                TimeUnit.MILLISECONDS.sleep(2000L);
                                continue;
                            }
                        }
                        if (!transport.isOpen()) {
                            throw new ConnectionFailException(String.format("Connected error after %d retries, last address: %s:%d", ThriftClientPool.this.poolConfig.getMaxReconnects(), serviceInfo.getHost(), serviceInfo.getPort()), e);
                        }
                    }
                    throw new ConnectionFailException(String.format("Connected error, address: %s:%d", serviceInfo.getHost(), serviceInfo.getPort()), e);
                }
                ThriftClient client = new ThriftClient(ThriftClientPool.this.clientFactory.createClient(transport), ThriftClientPool.this.pool, serviceInfo);
                LOG.debug("created new thrift pool for url:{}", (Object)url);
                return client;
            }

            public PooledObject<ThriftClient<T>> wrap(ThriftClient<T> obj) {
                return new DefaultPooledObject(obj);
            }

            public void destroyObject(PooledObject<ThriftClient<T>> p) throws Exception {
                ((ThriftClient)p.getObject()).closeClient();
                super.destroyObject(p);
            }
        }, this.poolConfig);
    }

    private TTransport getTransport(ServiceInfo serviceInfo) throws TTransportException {
        if (serviceInfo == null) {
            throw new NoBackendServiceException();
        }
        TConfiguration configuration = new TConfiguration();
        configuration.setMaxMessageSize(this.poolConfig.getMaxMessageSize());
        return new TFramedTransport((TTransport)new TSocket(new TConfiguration(), serviceInfo.getHost(), serviceInfo.getPort(), this.poolConfig.getConnectTimeout(), this.poolConfig.getSocketTimeout()), this.poolConfig.getMaxMessageSize());
    }

    public <X> X iface() {
        int attempt;
        ThriftClient client = null;
        for (attempt = 0; attempt < 5; ++attempt) {
            try {
                client = (ThriftClient)this.pool.borrowObject();
                if (!client.isDisConnected() && this.pingFactory.ping((TServiceClient)client.iface())) break;
                if (attempt > 1) {
                    LOG.warn("Maybe server is restarting, wait a while");
                    Thread.sleep(2000L);
                }
                this.pool.invalidateObject((Object)client);
                this.pool.clear();
                continue;
            }
            catch (Exception e) {
                if (e instanceof ThriftException) {
                    throw (ThriftException)e;
                }
                throw new ThriftException("Get client from pool failed", e);
            }
        }
        if (attempt >= 5) {
            throw new ThriftException("Client can not connect.");
        }
        AtomicBoolean returnToPool = new AtomicBoolean(false);
        ThriftClient finalClient = client;
        return (X)Proxy.newProxyInstance(this.getClass().getClassLoader(), finalClient.iface().getClass().getInterfaces(), (proxy, method, args) -> {
            if (returnToPool.get()) {
                throw new IllegalStateException("Client borrowed from pool can only used once!");
            }
            boolean success = false;
            try {
                Object result = method.invoke(finalClient.iface(), args);
                success = true;
                Object object = result;
                return object;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            finally {
                if (success) {
                    this.pool.returnObject((Object)finalClient);
                } else {
                    finalClient.closeClient();
                    this.pool.invalidateObject((Object)finalClient);
                }
                returnToPool.set(true);
            }
        });
    }
}

