/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.config;

import java.util.Optional;
import org.apache.amoro.config.DataExpirationConfig;
import org.apache.amoro.config.OptimizingConfig;
import org.apache.amoro.config.TagConfiguration;
import org.apache.amoro.shade.guava32.com.google.common.base.Objects;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TableConfiguration {
    private boolean expireSnapshotEnabled;
    private long snapshotTTLMinutes;
    private int snapshotMinCount;
    private long changeDataTTLMinutes;
    private boolean cleanOrphanEnabled;
    private long orphanExistingMinutes;
    private boolean deleteDanglingDeleteFilesEnabled;
    private OptimizingConfig optimizingConfig;
    private DataExpirationConfig expiringDataConfig;
    private TagConfiguration tagConfiguration;

    public boolean isExpireSnapshotEnabled() {
        return this.expireSnapshotEnabled;
    }

    public long getSnapshotTTLMinutes() {
        return this.snapshotTTLMinutes;
    }

    public int getSnapshotMinCount() {
        return this.snapshotMinCount;
    }

    public long getChangeDataTTLMinutes() {
        return this.changeDataTTLMinutes;
    }

    public boolean isCleanOrphanEnabled() {
        return this.cleanOrphanEnabled;
    }

    public long getOrphanExistingMinutes() {
        return this.orphanExistingMinutes;
    }

    public OptimizingConfig getOptimizingConfig() {
        return this.optimizingConfig;
    }

    public TableConfiguration setOptimizingConfig(OptimizingConfig optimizingConfig) {
        this.optimizingConfig = optimizingConfig;
        return this;
    }

    public TableConfiguration setExpireSnapshotEnabled(boolean expireSnapshotEnabled) {
        this.expireSnapshotEnabled = expireSnapshotEnabled;
        return this;
    }

    public TableConfiguration setSnapshotTTLMinutes(long snapshotTTLMinutes) {
        this.snapshotTTLMinutes = snapshotTTLMinutes;
        return this;
    }

    public TableConfiguration setSnapshotMinCount(int snapshotMinCount) {
        this.snapshotMinCount = snapshotMinCount;
        return this;
    }

    public TableConfiguration setChangeDataTTLMinutes(long changeDataTTLMinutes) {
        this.changeDataTTLMinutes = changeDataTTLMinutes;
        return this;
    }

    public TableConfiguration setCleanOrphanEnabled(boolean cleanOrphanEnabled) {
        this.cleanOrphanEnabled = cleanOrphanEnabled;
        return this;
    }

    public TableConfiguration setOrphanExistingMinutes(long orphanExistingMinutes) {
        this.orphanExistingMinutes = orphanExistingMinutes;
        return this;
    }

    public boolean isDeleteDanglingDeleteFilesEnabled() {
        return this.deleteDanglingDeleteFilesEnabled;
    }

    public TableConfiguration setDeleteDanglingDeleteFilesEnabled(boolean deleteDanglingDeleteFilesEnabled) {
        this.deleteDanglingDeleteFilesEnabled = deleteDanglingDeleteFilesEnabled;
        return this;
    }

    public DataExpirationConfig getExpiringDataConfig() {
        return Optional.ofNullable(this.expiringDataConfig).orElse(new DataExpirationConfig());
    }

    public TableConfiguration setExpiringDataConfig(DataExpirationConfig expiringDataConfig) {
        this.expiringDataConfig = expiringDataConfig;
        return this;
    }

    public TagConfiguration getTagConfiguration() {
        return Optional.ofNullable(this.tagConfiguration).orElse(new TagConfiguration());
    }

    public TableConfiguration setTagConfiguration(TagConfiguration tagConfiguration) {
        this.tagConfiguration = tagConfiguration;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableConfiguration that = (TableConfiguration)o;
        return this.expireSnapshotEnabled == that.expireSnapshotEnabled && this.snapshotTTLMinutes == that.snapshotTTLMinutes && this.snapshotMinCount == that.snapshotMinCount && this.changeDataTTLMinutes == that.changeDataTTLMinutes && this.cleanOrphanEnabled == that.cleanOrphanEnabled && this.orphanExistingMinutes == that.orphanExistingMinutes && this.deleteDanglingDeleteFilesEnabled == that.deleteDanglingDeleteFilesEnabled && Objects.equal((Object)this.optimizingConfig, (Object)that.optimizingConfig) && Objects.equal((Object)this.expiringDataConfig, (Object)that.expiringDataConfig) && Objects.equal((Object)this.tagConfiguration, (Object)that.tagConfiguration);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.expireSnapshotEnabled, this.snapshotTTLMinutes, this.snapshotMinCount, this.changeDataTTLMinutes, this.cleanOrphanEnabled, this.orphanExistingMinutes, this.deleteDanglingDeleteFilesEnabled, this.optimizingConfig, this.expiringDataConfig, this.tagConfiguration});
    }
}

