/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import org.apache.iceberg.ChangelogOperation;
import org.apache.iceberg.ChangelogScanTask;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;

public interface DeletedRowsScanTask
extends ChangelogScanTask,
ContentScanTask<DataFile> {
    public List<DeleteFile> addedDeletes();

    public List<DeleteFile> existingDeletes();

    @Override
    default public ChangelogOperation operation() {
        return ChangelogOperation.DELETE;
    }

    @Override
    default public long sizeBytes() {
        return this.length() + this.addedDeletes().stream().mapToLong(ContentFile::fileSizeInBytes).sum() + this.existingDeletes().stream().mapToLong(ContentFile::fileSizeInBytes).sum();
    }

    @Override
    default public int filesCount() {
        return 1 + this.addedDeletes().size() + this.existingDeletes().size();
    }
}

