/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing;

import java.util.LinkedList;
import javax.annotation.Nullable;
import org.apache.flink.runtime.asyncprocessing.AsyncExecutionController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EpochManager {
    private static final Logger LOG = LoggerFactory.getLogger(EpochManager.class);
    final AsyncExecutionController<?> asyncExecutionController;
    long epochNum = 0L;
    LinkedList<Epoch> outputQueue = new LinkedList();
    Epoch activeEpoch;

    public EpochManager(AsyncExecutionController<?> aec) {
        this.asyncExecutionController = aec;
        this.activeEpoch = new Epoch(this.epochNum++);
    }

    public Epoch onRecord() {
        ++this.activeEpoch.ongoingRecordCount;
        return this.activeEpoch;
    }

    public void onNonRecord(Runnable action, ParallelMode parallelMode) {
        LOG.trace("on NonRecord, old epoch: {}, outputQueue size: {}", (Object)this.activeEpoch, (Object)this.outputQueue.size());
        this.switchActiveEpoch(action);
        if (parallelMode == ParallelMode.SERIAL_BETWEEN_EPOCH) {
            this.asyncExecutionController.drainInflightRecords(0);
        }
    }

    public void completeOneRecord(Epoch epoch) {
        if (--epoch.ongoingRecordCount == 0) {
            this.tryFinishInQueue();
        }
    }

    private void tryFinishInQueue() {
        while (!this.outputQueue.isEmpty() && this.outputQueue.peek().tryFinish()) {
            LOG.trace("Finish epoch: {}, outputQueue size: {}", (Object)this.outputQueue.peek(), (Object)this.outputQueue.size());
            this.outputQueue.pop();
        }
    }

    private void switchActiveEpoch(Runnable action) {
        this.activeEpoch.close(action);
        this.outputQueue.offer(this.activeEpoch);
        this.activeEpoch = new Epoch(this.epochNum++);
        this.tryFinishInQueue();
    }

    public static class Epoch {
        long id;
        int ongoingRecordCount;
        @Nullable
        Runnable action;
        EpochStatus status;

        public Epoch(long id) {
            this.id = id;
            this.ongoingRecordCount = 0;
            this.status = EpochStatus.OPEN;
            this.action = null;
        }

        boolean tryFinish() {
            if (this.status == EpochStatus.FINISHED) {
                return true;
            }
            if (this.ongoingRecordCount == 0 && this.status == EpochStatus.CLOSED) {
                this.status = EpochStatus.FINISHED;
                if (this.action != null) {
                    this.action.run();
                }
                return true;
            }
            return false;
        }

        void close(Runnable action) {
            this.action = action;
            this.status = EpochStatus.CLOSED;
        }

        public String toString() {
            return String.format("Epoch{id=%d, ongoingRecord=%d, status=%s}", new Object[]{this.id, this.ongoingRecordCount, this.status});
        }
    }

    static enum EpochStatus {
        OPEN,
        CLOSED,
        FINISHED;

    }

    public static enum ParallelMode {
        SERIAL_BETWEEN_EPOCH,
        PARALLEL_BETWEEN_EPOCH;

    }
}

