/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.DataQualityTargetTable;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataQualityRulesetListDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataQualityRulesetListDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DataQualityRulesetListDetails.getter(DataQualityRulesetListDetails::name)).setter(DataQualityRulesetListDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DataQualityRulesetListDetails.getter(DataQualityRulesetListDetails::description)).setter(DataQualityRulesetListDetails.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedOn").getter(DataQualityRulesetListDetails.getter(DataQualityRulesetListDetails::createdOn)).setter(DataQualityRulesetListDetails.setter(Builder::createdOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedOn").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedOn").getter(DataQualityRulesetListDetails.getter(DataQualityRulesetListDetails::lastModifiedOn)).setter(DataQualityRulesetListDetails.setter(Builder::lastModifiedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedOn").build()}).build();
    private static final SdkField<DataQualityTargetTable> TARGET_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetTable").getter(DataQualityRulesetListDetails.getter(DataQualityRulesetListDetails::targetTable)).setter(DataQualityRulesetListDetails.setter(Builder::targetTable)).constructor(DataQualityTargetTable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTable").build()}).build();
    private static final SdkField<String> RECOMMENDATION_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationRunId").getter(DataQualityRulesetListDetails.getter(DataQualityRulesetListDetails::recommendationRunId)).setter(DataQualityRulesetListDetails.setter(Builder::recommendationRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationRunId").build()}).build();
    private static final SdkField<Integer> RULE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RuleCount").getter(DataQualityRulesetListDetails.getter(DataQualityRulesetListDetails::ruleCount)).setter(DataQualityRulesetListDetails.setter(Builder::ruleCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, CREATED_ON_FIELD, LAST_MODIFIED_ON_FIELD, TARGET_TABLE_FIELD, RECOMMENDATION_RUN_ID_FIELD, RULE_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final Instant createdOn;
    private final Instant lastModifiedOn;
    private final DataQualityTargetTable targetTable;
    private final String recommendationRunId;
    private final Integer ruleCount;

    private DataQualityRulesetListDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.createdOn = builder.createdOn;
        this.lastModifiedOn = builder.lastModifiedOn;
        this.targetTable = builder.targetTable;
        this.recommendationRunId = builder.recommendationRunId;
        this.ruleCount = builder.ruleCount;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createdOn() {
        return this.createdOn;
    }

    public final Instant lastModifiedOn() {
        return this.lastModifiedOn;
    }

    public final DataQualityTargetTable targetTable() {
        return this.targetTable;
    }

    public final String recommendationRunId() {
        return this.recommendationRunId;
    }

    public final Integer ruleCount() {
        return this.ruleCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityRulesetListDetails)) {
            return false;
        }
        DataQualityRulesetListDetails other = (DataQualityRulesetListDetails)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdOn(), other.createdOn()) && Objects.equals(this.lastModifiedOn(), other.lastModifiedOn()) && Objects.equals(this.targetTable(), other.targetTable()) && Objects.equals(this.recommendationRunId(), other.recommendationRunId()) && Objects.equals(this.ruleCount(), other.ruleCount());
    }

    public final String toString() {
        return ToString.builder((String)"DataQualityRulesetListDetails").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("CreatedOn", (Object)this.createdOn()).add("LastModifiedOn", (Object)this.lastModifiedOn()).add("TargetTable", (Object)this.targetTable()).add("RecommendationRunId", (Object)this.recommendationRunId()).add("RuleCount", (Object)this.ruleCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreatedOn": {
                return Optional.ofNullable(clazz.cast(this.createdOn()));
            }
            case "LastModifiedOn": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedOn()));
            }
            case "TargetTable": {
                return Optional.ofNullable(clazz.cast(this.targetTable()));
            }
            case "RecommendationRunId": {
                return Optional.ofNullable(clazz.cast(this.recommendationRunId()));
            }
            case "RuleCount": {
                return Optional.ofNullable(clazz.cast(this.ruleCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataQualityRulesetListDetails, T> g) {
        return obj -> g.apply((DataQualityRulesetListDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private Instant createdOn;
        private Instant lastModifiedOn;
        private DataQualityTargetTable targetTable;
        private String recommendationRunId;
        private Integer ruleCount;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityRulesetListDetails model) {
            this.name(model.name);
            this.description(model.description);
            this.createdOn(model.createdOn);
            this.lastModifiedOn(model.lastModifiedOn);
            this.targetTable(model.targetTable);
            this.recommendationRunId(model.recommendationRunId);
            this.ruleCount(model.ruleCount);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedOn() {
            return this.createdOn;
        }

        public final void setCreatedOn(Instant createdOn) {
            this.createdOn = createdOn;
        }

        @Override
        public final Builder createdOn(Instant createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public final Instant getLastModifiedOn() {
            return this.lastModifiedOn;
        }

        public final void setLastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        @Override
        public final Builder lastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        public final DataQualityTargetTable.Builder getTargetTable() {
            return this.targetTable != null ? this.targetTable.toBuilder() : null;
        }

        public final void setTargetTable(DataQualityTargetTable.BuilderImpl targetTable) {
            this.targetTable = targetTable != null ? targetTable.build() : null;
        }

        @Override
        public final Builder targetTable(DataQualityTargetTable targetTable) {
            this.targetTable = targetTable;
            return this;
        }

        public final String getRecommendationRunId() {
            return this.recommendationRunId;
        }

        public final void setRecommendationRunId(String recommendationRunId) {
            this.recommendationRunId = recommendationRunId;
        }

        @Override
        public final Builder recommendationRunId(String recommendationRunId) {
            this.recommendationRunId = recommendationRunId;
            return this;
        }

        public final Integer getRuleCount() {
            return this.ruleCount;
        }

        public final void setRuleCount(Integer ruleCount) {
            this.ruleCount = ruleCount;
        }

        @Override
        public final Builder ruleCount(Integer ruleCount) {
            this.ruleCount = ruleCount;
            return this;
        }

        public DataQualityRulesetListDetails build() {
            return new DataQualityRulesetListDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataQualityRulesetListDetails> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder createdOn(Instant var1);

        public Builder lastModifiedOn(Instant var1);

        public Builder targetTable(DataQualityTargetTable var1);

        default public Builder targetTable(Consumer<DataQualityTargetTable.Builder> targetTable) {
            return this.targetTable((DataQualityTargetTable)((DataQualityTargetTable.Builder)DataQualityTargetTable.builder().applyMutation(targetTable)).build());
        }

        public Builder recommendationRunId(String var1);

        public Builder ruleCount(Integer var1);
    }
}

