/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

public final class ParquetReadSupport$
implements Logging {
    public static ParquetReadSupport$ MODULE$;
    private final String SPARK_ROW_REQUESTED_SCHEMA;
    private final String SPARK_METADATA_KEY;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ParquetReadSupport$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String SPARK_ROW_REQUESTED_SCHEMA() {
        return this.SPARK_ROW_REQUESTED_SCHEMA;
    }

    public String SPARK_METADATA_KEY() {
        return this.SPARK_METADATA_KEY;
    }

    public String generateFakeColumnName() {
        return new StringBuilder(11).append("_fake_name_").append(UUID.randomUUID()).toString();
    }

    public MessageType getRequestedSchema(MessageType parquetFileSchema, StructType catalystRequestedSchema, Configuration conf, boolean enableVectorizedReader) {
        boolean caseSensitive = conf.getBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.CASE_SENSITIVE().defaultValue().get()));
        boolean schemaPruningEnabled = conf.getBoolean(SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().key(), BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().defaultValue().get()));
        boolean useFieldId = conf.getBoolean(SQLConf$.MODULE$.PARQUET_FIELD_ID_READ_ENABLED().key(), BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.PARQUET_FIELD_ID_READ_ENABLED().defaultValue().get()));
        boolean ignoreMissingIds = conf.getBoolean(SQLConf$.MODULE$.IGNORE_MISSING_PARQUET_FIELD_ID().key(), BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.IGNORE_MISSING_PARQUET_FIELD_ID().defaultValue().get()));
        if (!ignoreMissingIds && !this.containsFieldIds((Type)parquetFileSchema) && ParquetUtils$.MODULE$.hasFieldIds(catalystRequestedSchema)) {
            throw new RuntimeException(new StringBuilder(181).append("Spark read schema expects field Ids, but Parquet file schema doesn't contain any field Ids.\nPlease remove the field ids from Spark schema or ignore missing ids by ").append("setting `").append(SQLConf$.MODULE$.IGNORE_MISSING_PARQUET_FIELD_ID().key()).append(" = true`\n").append(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(116).append("\n           |Spark read schema:\n           |").append(catalystRequestedSchema.prettyJson()).append("\n           |\n           |Parquet file schema:\n           |").append(parquetFileSchema.toString()).append("\n           |").toString())).stripMargin()).toString());
        }
        MessageType parquetClippedSchema = this.clipParquetSchema(parquetFileSchema, catalystRequestedSchema, caseSensitive, useFieldId);
        MessageType parquetRequestedSchema = schemaPruningEnabled && !enableVectorizedReader ? (MessageType)this.intersectParquetGroups((GroupType)parquetClippedSchema, (GroupType)parquetFileSchema).map((Function1 & Serializable & scala.Serializable)groupType -> new MessageType(groupType.getName(), groupType.getFields())).getOrElse((Function0 & Serializable & scala.Serializable)() -> ParquetSchemaConverter$.MODULE$.EMPTY_MESSAGE()) : parquetClippedSchema;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(273).append("Going to read the following fields from the Parquet file with the following schema:\n         |Parquet file schema:\n         |").append(parquetFileSchema).append("\n         |Parquet clipped schema:\n         |").append(parquetClippedSchema).append("\n         |Parquet requested schema:\n         |").append(parquetRequestedSchema).append("\n         |Catalyst requested schema:\n         |").append(catalystRequestedSchema.treeString()).append("\n       ").toString())).stripMargin());
        return parquetRequestedSchema;
    }

    public MessageType clipParquetSchema(MessageType parquetSchema, StructType catalystSchema, boolean caseSensitive) {
        return this.clipParquetSchema(parquetSchema, catalystSchema, caseSensitive, false);
    }

    public MessageType clipParquetSchema(MessageType parquetSchema, StructType catalystSchema, boolean caseSensitive, boolean useFieldId) {
        Seq<Type> clippedParquetFields = this.clipParquetGroupFields(parquetSchema.asGroupType(), catalystSchema, caseSensitive, useFieldId);
        return clippedParquetFields.isEmpty() ? ParquetSchemaConverter$.MODULE$.EMPTY_MESSAGE() : (MessageType)Types.buildMessage().addFields((Type[])clippedParquetFields.toArray(ClassTag$.MODULE$.apply(Type.class))).named(ParquetSchemaConverter$.MODULE$.SPARK_PARQUET_SCHEMA_NAME());
    }

    public boolean clipParquetSchema$default$3() {
        return true;
    }

    private Type clipParquetType(Type parquetType, DataType catalystType, boolean caseSensitive, boolean useFieldId) {
        MapType mapType;
        Type type;
        ArrayType arrayType;
        DataType dataType = catalystType;
        if (dataType instanceof ArrayType && !this.isPrimitiveCatalystType((arrayType = (ArrayType)dataType).elementType())) {
            type = this.clipParquetListType(parquetType.asGroupType(), arrayType.elementType(), caseSensitive, useFieldId);
        } else if (!(!(dataType instanceof MapType) || this.isPrimitiveCatalystType((mapType = (MapType)dataType).keyType()) && this.isPrimitiveCatalystType(mapType.valueType()))) {
            type = this.clipParquetMapType(parquetType.asGroupType(), mapType.keyType(), mapType.valueType(), caseSensitive, useFieldId);
        } else if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            type = this.clipParquetGroup(parquetType.asGroupType(), structType, caseSensitive, useFieldId);
        } else {
            type = parquetType;
        }
        Type newParquetType = type;
        return useFieldId && parquetType.getId() != null ? newParquetType.withId(parquetType.getId().intValue()) : newParquetType;
    }

    private boolean isPrimitiveCatalystType(DataType dataType) {
        DataType dataType2 = dataType;
        boolean bl = dataType2 instanceof ArrayType ? true : (dataType2 instanceof MapType ? true : dataType2 instanceof StructType);
        boolean bl2 = !bl;
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Type clipParquetListType(GroupType parquetList, DataType elementType, boolean caseSensitive, boolean useFieldId) {
        GroupType repeatedGroup;
        Type type;
        block5: {
            block4: {
                Predef$.MODULE$.assert(!this.isPrimitiveCatalystType(elementType));
                if (parquetList.getLogicalTypeAnnotation() == null && parquetList.isRepetition(Type.Repetition.REPEATED)) {
                    type = this.clipParquetType((Type)parquetList, elementType, caseSensitive, useFieldId);
                    return type;
                }
                Predef$.MODULE$.assert(parquetList.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.ListLogicalTypeAnnotation, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(110).append("Invalid Parquet schema. Logical type annotation of annotated Parquet lists must be ListLogicalTypeAnnotation: ").append(parquetList.toString()).toString());
                Predef$.MODULE$.assert(parquetList.getFieldCount() == 1 && parquetList.getType(0).isRepetition(Type.Repetition.REPEATED), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("Invalid Parquet schema. LIST-annotated group should only have exactly one repeated field: ").append(parquetList).toString());
                Predef$.MODULE$.assert(!parquetList.getType(0).isPrimitive());
                repeatedGroup = parquetList.getType(0).asGroupType();
                if (repeatedGroup.getFieldCount() > 1) break block4;
                String string = repeatedGroup.getName();
                String string2 = "array";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block4;
                String string3 = repeatedGroup.getName();
                String string4 = new StringBuilder(6).append(parquetList.getName()).append("_tuple").toString();
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block5;
            }
            type = (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)parquetList.getRepetition()).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField(this.clipParquetType((Type)repeatedGroup, elementType, caseSensitive, useFieldId)).named(parquetList.getName());
            return type;
        }
        GroupType newRepeatedGroup = (GroupType)Types.repeatedGroup().addField(this.clipParquetType(repeatedGroup.getType(0), elementType, caseSensitive, useFieldId)).named(repeatedGroup.getName());
        GroupType newElementType = useFieldId && repeatedGroup.getId() != null ? newRepeatedGroup.withId(repeatedGroup.getId().intValue()) : newRepeatedGroup;
        type = (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)parquetList.getRepetition()).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField((Type)newElementType).named(parquetList.getName());
        return type;
    }

    private GroupType clipParquetMapType(GroupType parquetMap, DataType keyType, DataType valueType, boolean caseSensitive, boolean useFieldId) {
        Predef$.MODULE$.assert(!this.isPrimitiveCatalystType(keyType) || !this.isPrimitiveCatalystType(valueType));
        GroupType repeatedGroup = parquetMap.getType(0).asGroupType();
        Type parquetKeyType = repeatedGroup.getType(0);
        Type parquetValueType = repeatedGroup.getType(1);
        GroupType newRepeatedGroup = (GroupType)((Types.BaseGroupBuilder)Types.repeatedGroup().as(repeatedGroup.getLogicalTypeAnnotation())).addField(this.clipParquetType(parquetKeyType, keyType, caseSensitive, useFieldId)).addField(this.clipParquetType(parquetValueType, valueType, caseSensitive, useFieldId)).named(repeatedGroup.getName());
        GroupType clippedRepeatedGroup = useFieldId && repeatedGroup.getId() != null ? newRepeatedGroup.withId(repeatedGroup.getId().intValue()) : newRepeatedGroup;
        return (GroupType)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)parquetMap.getRepetition()).as(parquetMap.getLogicalTypeAnnotation())).addField((Type)clippedRepeatedGroup).named(parquetMap.getName());
    }

    private GroupType clipParquetGroup(GroupType parquetRecord, StructType structType, boolean caseSensitive, boolean useFieldId) {
        Seq<Type> clippedParquetFields = this.clipParquetGroupFields(parquetRecord, structType, caseSensitive, useFieldId);
        return (GroupType)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)parquetRecord.getRepetition()).as(parquetRecord.getLogicalTypeAnnotation())).addFields((Type[])clippedParquetFields.toArray(ClassTag$.MODULE$.apply(Type.class))).named(parquetRecord.getName());
    }

    private Seq<Type> clipParquetGroupFields(GroupType parquetRecord, StructType structType, boolean caseSensitive, boolean useFieldId) {
        LazyRef caseSensitiveParquetFieldMap$lzy = new LazyRef();
        LazyRef caseInsensitiveParquetFieldMap$lzy = new LazyRef();
        LazyRef idToParquetFieldMap$lzy = new LazyRef();
        boolean x$1 = false;
        boolean x$2 = useFieldId;
        Enumeration.Value x$3 = SparkToParquetSchemaConverter$.MODULE$.$lessinit$greater$default$2();
        SparkToParquetSchemaConverter toParquet = new SparkToParquetSchemaConverter(x$1, x$3, x$2);
        boolean shouldMatchById = useFieldId && ParquetUtils$.MODULE$.hasFieldIds(structType);
        return (Seq)structType.map((Function1 & Serializable & scala.Serializable)f -> shouldMatchById && ParquetUtils$.MODULE$.hasFieldId((StructField)f) ? ParquetReadSupport$.matchIdField$1(f, caseSensitive, useFieldId, toParquet, idToParquetFieldMap$lzy, parquetRecord) : (caseSensitive ? ParquetReadSupport$.matchCaseSensitiveField$1(f, caseSensitive, useFieldId, toParquet, caseSensitiveParquetFieldMap$lzy, parquetRecord) : ParquetReadSupport$.matchCaseInsensitiveField$1(f, caseSensitive, useFieldId, toParquet, caseInsensitiveParquetFieldMap$lzy, parquetRecord)), Seq$.MODULE$.canBuildFrom());
    }

    private Option<GroupType> intersectParquetGroups(GroupType groupType1, GroupType groupType2) {
        Buffer fields = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(groupType1.getFields()).asScala()).filter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)groupType2.containsField(field.getName())))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            GroupType groupType;
            Type field2;
            Type type = x0$1;
            Iterable iterable = type instanceof GroupType ? ((field2 = groupType2.getType((groupType = (GroupType)type).getName())).isPrimitive() ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable(MODULE$.intersectParquetGroups(groupType, field2.asGroupType()))) : Option$.MODULE$.option2Iterable((Option)new Some((Object)type));
            return iterable;
        }, Buffer$.MODULE$.canBuildFrom());
        return fields.nonEmpty() ? new Some((Object)groupType1.withNewFields((List)JavaConverters$.MODULE$.bufferAsJavaListConverter(fields).asJava())) : None$.MODULE$;
    }

    public StructType expandUDT(StructType schema) {
        return (StructType)ParquetReadSupport$.expand$1((DataType)schema);
    }

    public boolean containsFieldIds(Type schema2) {
        boolean bl;
        Type type = schema2;
        if (type instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            bl = primitiveType.getId() != null;
        } else if (type instanceof GroupType) {
            GroupType groupType = (GroupType)type;
            bl = groupType.getId() != null || ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(groupType.getFields()).asScala()).exists((Function1 & Serializable & scala.Serializable)schema -> BoxesRunTime.boxToBoolean((boolean)ParquetReadSupport$.MODULE$.containsFieldIds(schema)));
        } else {
            throw new MatchError((Object)type);
        }
        return bl;
    }

    private static final /* synthetic */ Map caseSensitiveParquetFieldMap$lzycompute$1(LazyRef caseSensitiveParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        Map map;
        LazyRef lazyRef = caseSensitiveParquetFieldMap$lzy$1;
        synchronized (lazyRef) {
            map = caseSensitiveParquetFieldMap$lzy$1.initialized() ? (Map)caseSensitiveParquetFieldMap$lzy$1.value() : (Map)caseSensitiveParquetFieldMap$lzy$1.initialize((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(parquetRecord$1.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.getName()), f), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        }
        return map;
    }

    private static final Map caseSensitiveParquetFieldMap$1(LazyRef caseSensitiveParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        return caseSensitiveParquetFieldMap$lzy$1.initialized() ? (Map)caseSensitiveParquetFieldMap$lzy$1.value() : ParquetReadSupport$.caseSensitiveParquetFieldMap$lzycompute$1(caseSensitiveParquetFieldMap$lzy$1, parquetRecord$1);
    }

    private static final /* synthetic */ Map caseInsensitiveParquetFieldMap$lzycompute$1(LazyRef caseInsensitiveParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        Map map;
        LazyRef lazyRef = caseInsensitiveParquetFieldMap$lzy$1;
        synchronized (lazyRef) {
            map = caseInsensitiveParquetFieldMap$lzy$1.initialized() ? (Map)caseInsensitiveParquetFieldMap$lzy$1.value() : (Map)caseInsensitiveParquetFieldMap$lzy$1.initialize((Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(parquetRecord$1.getFields()).asScala()).groupBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName().toLowerCase(Locale.ROOT)));
        }
        return map;
    }

    private static final Map caseInsensitiveParquetFieldMap$1(LazyRef caseInsensitiveParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        return caseInsensitiveParquetFieldMap$lzy$1.initialized() ? (Map)caseInsensitiveParquetFieldMap$lzy$1.value() : ParquetReadSupport$.caseInsensitiveParquetFieldMap$lzycompute$1(caseInsensitiveParquetFieldMap$lzy$1, parquetRecord$1);
    }

    public static final /* synthetic */ boolean $anonfun$clipParquetGroupFields$3(Type x$2) {
        return x$2.getId() != null;
    }

    public static final /* synthetic */ int $anonfun$clipParquetGroupFields$4(Type f) {
        return f.getId().intValue();
    }

    private static final /* synthetic */ Map idToParquetFieldMap$lzycompute$1(LazyRef idToParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        Map map;
        LazyRef lazyRef = idToParquetFieldMap$lzy$1;
        synchronized (lazyRef) {
            map = idToParquetFieldMap$lzy$1.initialized() ? (Map)idToParquetFieldMap$lzy$1.value() : (Map)idToParquetFieldMap$lzy$1.initialize((Object)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(parquetRecord$1.getFields()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ParquetReadSupport$.$anonfun$clipParquetGroupFields$3(x$2)))).groupBy((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToInteger((int)ParquetReadSupport$.$anonfun$clipParquetGroupFields$4(f))));
        }
        return map;
    }

    private static final Map idToParquetFieldMap$1(LazyRef idToParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        return idToParquetFieldMap$lzy$1.initialized() ? (Map)idToParquetFieldMap$lzy$1.value() : ParquetReadSupport$.idToParquetFieldMap$lzycompute$1(idToParquetFieldMap$lzy$1, parquetRecord$1);
    }

    private static final Type matchCaseSensitiveField$1(StructField f, boolean caseSensitive$1, boolean useFieldId$1, SparkToParquetSchemaConverter toParquet$1, LazyRef caseSensitiveParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        return (Type)ParquetReadSupport$.caseSensitiveParquetFieldMap$1(caseSensitiveParquetFieldMap$lzy$1, parquetRecord$1).get((Object)f.name()).map((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.clipParquetType((Type)x$3, f.dataType(), caseSensitive$1, useFieldId$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> toParquet$1.convertField(f));
    }

    private static final Type matchCaseInsensitiveField$1(StructField f, boolean caseSensitive$1, boolean useFieldId$1, SparkToParquetSchemaConverter toParquet$1, LazyRef caseInsensitiveParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        return (Type)ParquetReadSupport$.caseInsensitiveParquetFieldMap$1(caseInsensitiveParquetFieldMap$lzy$1, parquetRecord$1).get((Object)f.name().toLowerCase(Locale.ROOT)).map((Function1 & Serializable & scala.Serializable)parquetTypes -> {
            if (parquetTypes.size() > 1) {
                String parquetTypesString = ((TraversableOnce)parquetTypes.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getName(), Buffer$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
                throw QueryExecutionErrors$.MODULE$.foundDuplicateFieldInCaseInsensitiveModeError(f.name(), parquetTypesString);
            }
            return MODULE$.clipParquetType((Type)parquetTypes.head(), f.dataType(), caseSensitive$1, useFieldId$1);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> toParquet$1.convertField(f));
    }

    private static final Type matchIdField$1(StructField f, boolean caseSensitive$1, boolean useFieldId$1, SparkToParquetSchemaConverter toParquet$1, LazyRef idToParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        int fieldId = ParquetUtils$.MODULE$.getFieldId(f);
        return (Type)ParquetReadSupport$.idToParquetFieldMap$1(idToParquetFieldMap$lzy$1, parquetRecord$1).get((Object)BoxesRunTime.boxToInteger((int)fieldId)).map((Function1 & Serializable & scala.Serializable)parquetTypes -> {
            if (parquetTypes.size() > 1) {
                String parquetTypesString = ((TraversableOnce)parquetTypes.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getName(), Buffer$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
                throw QueryExecutionErrors$.MODULE$.foundDuplicateFieldInFieldIdLookupModeError(fieldId, parquetTypesString);
            }
            return MODULE$.clipParquetType((Type)parquetTypes.head(), f.dataType(), caseSensitive$1, useFieldId$1);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> toParquet$1.convertField(f.copy(MODULE$.generateFakeColumnName(), f.copy$default$2(), f.copy$default$3(), f.copy$default$4())));
    }

    private static final DataType expand$1(DataType dataType) {
        ArrayType arrayType;
        DataType dataType2 = dataType;
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType2 = (ArrayType)dataType2;
            arrayType = arrayType2.copy(ParquetReadSupport$.expand$1(arrayType2.elementType()), arrayType2.copy$default$2());
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            arrayType = mapType.copy(ParquetReadSupport$.expand$1(mapType.keyType()), ParquetReadSupport$.expand$1(mapType.valueType()), mapType.copy$default$3());
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            StructField[] expandedFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).map((Function1 & Serializable & scala.Serializable)f -> {
                DataType x$1 = ParquetReadSupport$.expand$1(f.dataType());
                String x$2 = f.copy$default$1();
                boolean x$3 = f.copy$default$3();
                Metadata x$4 = f.copy$default$4();
                return f.copy(x$2, x$1, x$3, x$4);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
            arrayType = structType.copy(expandedFields);
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            arrayType = userDefinedType.sqlType();
        } else {
            arrayType = dataType2;
        }
        return arrayType;
    }

    private ParquetReadSupport$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.SPARK_ROW_REQUESTED_SCHEMA = "org.apache.spark.sql.parquet.row.requested_schema";
        this.SPARK_METADATA_KEY = "org.apache.spark.sql.parquet.row.metadata";
    }
}

