/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetColumn;
import org.apache.spark.sql.execution.datasources.parquet.ParquetColumn$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ee\u0001\u0002\u000f\u001e\u00011B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\to\u0001\u0011\t\u0011)A\u0005i!A\u0001\b\u0001B\u0001B\u0003%A\u0007\u0003\u0005:\u0001\t\u0005\t\u0015!\u00035\u0011\u0015Q\u0004\u0001\"\u0001<\u0011\u0015Q\u0004\u0001\"\u0001C\u0011\u0015Q\u0004\u0001\"\u0001L\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u0015)\u0007\u0001\"\u0001g\u0011\u001d\u0001\b!%A\u0005\u0002EDQ\u0001 \u0001\u0005\nuD\u0001\"a\u0004\u0001#\u0003%I!\u001d\u0005\b\u0003#\u0001A\u0011BA\n\u0011\u001d\ty\u0003\u0001C\u0001\u0003cA\u0011\"!\u0013\u0001#\u0003%\t!a\u0013\t\u000f\u0005=\u0003\u0001\"\u0003\u0002R!I\u0011q\f\u0001\u0012\u0002\u0013%\u00111\n\u0005\b\u0003C\u0002A\u0011BA2\u0011%\tI\u0007AI\u0001\n\u0013\tY\u0005\u0003\u0005\u0002l\u0001!\t!HA7\u000f%\ti(HA\u0001\u0012\u0003\tyH\u0002\u0005\u001d;\u0005\u0005\t\u0012AAA\u0011\u0019Qd\u0003\"\u0001\u0002\u0004\"I\u0011Q\u0011\f\u0012\u0002\u0013\u0005\u0011q\u0011\u0005\n\u0003\u00173\u0012\u0013!C\u0001\u0003\u000fC\u0011\"!$\u0017#\u0003%\t!a\"\t\u0013\u0005=e#%A\u0005\u0002\u0005\u001d%!\b)beF,X\r\u001e+p'B\f'o[*dQ\u0016l\u0017mQ8om\u0016\u0014H/\u001a:\u000b\u0005yy\u0012a\u00029beF,X\r\u001e\u0006\u0003A\u0005\n1\u0002Z1uCN|WO]2fg*\u0011!eI\u0001\nKb,7-\u001e;j_:T!\u0001J\u0013\u0002\u0007M\fHN\u0003\u0002'O\u0005)1\u000f]1sW*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g\u0003Q\t7o];nK\nKg.\u0019:z\u0013N\u001cFO]5oOB\u0011a&N\u0005\u0003m=\u0012qAQ8pY\u0016\fg.\u0001\fbgN,X.Z%oif2\u0014j\u001d+j[\u0016\u001cH/Y7q\u00035\u0019\u0017m]3TK:\u001c\u0018\u000e^5wK\u0006Ya.\u00198pg\u0006\u001bHj\u001c8h\u0003\u0019a\u0014N\\5u}Q)AHP A\u0003B\u0011Q\bA\u0007\u0002;!91'\u0002I\u0001\u0002\u0004!\u0004bB\u001c\u0006!\u0003\u0005\r\u0001\u000e\u0005\bq\u0015\u0001\n\u00111\u00015\u0011\u001dIT\u0001%AA\u0002Q\"\"\u0001P\"\t\u000b\u00113\u0001\u0019A#\u0002\t\r|gN\u001a\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\u000e\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u0015\u001e\u0013qaU)M\u0007>tg\r\u0006\u0002=\u0019\")Ai\u0002a\u0001\u001bB\u0011aJU\u0007\u0002\u001f*\u0011A\t\u0015\u0006\u0003#\u001e\na\u0001[1e_>\u0004\u0018BA*P\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u000691m\u001c8wKJ$HC\u0001,]!\t9&,D\u0001Y\u0015\tI6%A\u0003usB,7/\u0003\u0002\\1\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000buC\u0001\u0019\u00010\u0002\u001bA\f'/];fiN\u001b\u0007.Z7b!\ty6-D\u0001a\u0015\t\t'-\u0001\u0004tG\",W.\u0019\u0006\u0003=\u001dJ!\u0001\u001a1\u0003\u00175+7o]1hKRK\b/Z\u0001\u0015G>tg/\u001a:u!\u0006\u0014\u0018/^3u\u0007>dW/\u001c8\u0015\u0007\u001dT7\u000e\u0005\u0002>Q&\u0011\u0011.\b\u0002\u000e!\u0006\u0014\u0018/^3u\u0007>dW/\u001c8\t\u000buK\u0001\u0019\u00010\t\u000f1L\u0001\u0013!a\u0001[\u0006y1\u000f]1sWJ+\u0017\rZ*dQ\u0016l\u0017\rE\u0002/]ZK!a\\\u0018\u0003\r=\u0003H/[8o\u0003y\u0019wN\u001c<feR\u0004\u0016M]9vKR\u001cu\u000e\\;n]\u0012\"WMZ1vYR$#'F\u0001sU\ti7oK\u0001u!\t)(0D\u0001w\u0015\t9\b0A\u0005v]\u000eDWmY6fI*\u0011\u0011pL\u0001\u000bC:tw\u000e^1uS>t\u0017BA>w\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0010G>tg/\u001a:u\u0013:$XM\u001d8bYR!qM`A\u0007\u0011\u0019y8\u00021\u0001\u0002\u0002\u0005YqM]8va\u000e{G.^7o!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004E\u0006\u0011\u0011n\\\u0005\u0005\u0003\u0017\t)AA\u0007He>,\boQ8mk6t\u0017j\u0014\u0005\bY.\u0001\n\u00111\u0001n\u0003e\u0019wN\u001c<feRLe\u000e^3s]\u0006dG\u0005Z3gCVdG\u000f\n\u001a\u0002%9|'/\\1mSj,g)[3mI:\u000bW.\u001a\u000b\u0005\u0003+\tY\u0003\u0005\u0003\u0002\u0018\u0005\u0015b\u0002BA\r\u0003C\u00012!a\u00070\u001b\t\tiBC\u0002\u0002 -\na\u0001\u0010:p_Rt\u0014bAA\u0012_\u00051\u0001K]3eK\u001aLA!a\n\u0002*\t11\u000b\u001e:j]\u001eT1!a\t0\u0011\u001d\ti#\u0004a\u0001\u0003+\tAA\\1nK\u0006a1m\u001c8wKJ$h)[3mIR)q-a\r\u0002>!9\u0011Q\u0007\bA\u0002\u0005]\u0012!\u00024jK2$\u0007\u0003BA\u0002\u0003sIA!a\u000f\u0002\u0006\tA1i\u001c7v[:Lu\nC\u0005\u0002@9\u0001\n\u00111\u0001\u0002B\u0005i1\u000f]1sWJ+\u0017\r\u001a+za\u0016\u0004BA\f8\u0002DA\u0019q+!\u0012\n\u0007\u0005\u001d\u0003L\u0001\u0005ECR\fG+\u001f9f\u0003Y\u0019wN\u001c<feR4\u0015.\u001a7eI\u0011,g-Y;mi\u0012\u0012TCAA'U\r\t\te]\u0001\u0016G>tg/\u001a:u!JLW.\u001b;jm\u00164\u0015.\u001a7e)\u00159\u00171KA/\u0011\u001d\t)\u0006\u0005a\u0001\u0003/\nq\u0002\u001d:j[&$\u0018N^3D_2,XN\u001c\t\u0005\u0003\u0007\tI&\u0003\u0003\u0002\\\u0005\u0015!!\u0005)sS6LG/\u001b<f\u0007>dW/\u001c8J\u001f\"I\u0011q\b\t\u0011\u0002\u0003\u0007\u0011\u0011I\u0001 G>tg/\u001a:u!JLW.\u001b;jm\u00164\u0015.\u001a7eI\u0011,g-Y;mi\u0012\u0012\u0014!E2p]Z,'\u000f^$s_V\u0004h)[3mIR)q-!\u001a\u0002h!1qP\u0005a\u0001\u0003\u0003A\u0011\"a\u0010\u0013!\u0003\u0005\r!!\u0011\u00027\r|gN^3si\u001e\u0013x.\u001e9GS\u0016dG\r\n3fM\u0006,H\u000e\u001e\u00133\u00035I7/\u00127f[\u0016tG\u000fV=qKR)A'a\u001c\u0002z!9\u0011\u0011\u000f\u000bA\u0002\u0005M\u0014\u0001\u0004:fa\u0016\fG/\u001a3UsB,\u0007cA0\u0002v%\u0019\u0011q\u000f1\u0003\tQK\b/\u001a\u0005\b\u0003w\"\u0002\u0019AA\u000b\u0003)\u0001\u0018M]3oi:\u000bW.Z\u0001\u001e!\u0006\u0014\u0018/^3u)>\u001c\u0006/\u0019:l'\u000eDW-\\1D_:4XM\u001d;feB\u0011QHF\n\u0003-5\"\"!a \u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\tII\u000b\u00025g\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C\u0007")
public class ParquetToSparkSchemaConverter {
    private final boolean assumeBinaryIsString;
    private final boolean assumeInt96IsTimestamp;
    private final boolean caseSensitive;
    private final boolean nanosAsLong;

    public static boolean $lessinit$greater$default$4() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean $lessinit$greater$default$3() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$2() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$1() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$1();
    }

    public StructType convert(MessageType parquetSchema) {
        MessageColumnIO column = new ColumnIOFactory().getColumnIO(parquetSchema);
        ParquetColumn converted = this.convertInternal((GroupColumnIO)column, this.convertInternal$default$2());
        return (StructType)converted.sparkType();
    }

    public ParquetColumn convertParquetColumn(MessageType parquetSchema, Option<StructType> sparkReadSchema) {
        MessageColumnIO column = new ColumnIOFactory().getColumnIO(parquetSchema);
        return this.convertInternal((GroupColumnIO)column, sparkReadSchema);
    }

    public Option<StructType> convertParquetColumn$default$2() {
        return None$.MODULE$;
    }

    private ParquetColumn convertInternal(GroupColumnIO groupColumn, Option<StructType> sparkReadSchema) {
        Option schemaMapOpt = sparkReadSchema.map((Function1 & Serializable & scala.Serializable)schema -> ((TraversableOnce)schema.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.normalizeFieldName(f.name())), f), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        IndexedSeq converted = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), groupColumn.getChildrenCount()).map((Function1 & Serializable & scala.Serializable)i -> ParquetToSparkSchemaConverter.$anonfun$convertInternal$3(this, groupColumn, schemaMapOpt, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        return ParquetColumn$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)converted.map((Function1 & Serializable & scala.Serializable)x$3 -> (StructField)x$3._1(), IndexedSeq$.MODULE$.canBuildFrom())), groupColumn, (Seq<ParquetColumn>)((Seq)converted.map((Function1 & Serializable & scala.Serializable)x$4 -> (ParquetColumn)x$4._2(), IndexedSeq$.MODULE$.canBuildFrom())));
    }

    private Option<StructType> convertInternal$default$2() {
        return None$.MODULE$;
    }

    private String normalizeFieldName(String name) {
        return this.caseSensitive ? name : name.toLowerCase(Locale.ROOT);
    }

    public ParquetColumn convertField(ColumnIO field, Option<DataType> sparkReadType) {
        ParquetColumn parquetColumn;
        ColumnIO columnIO = field;
        if (columnIO instanceof PrimitiveColumnIO) {
            PrimitiveColumnIO primitiveColumnIO = (PrimitiveColumnIO)columnIO;
            parquetColumn = this.convertPrimitiveField(primitiveColumnIO, sparkReadType);
        } else if (columnIO instanceof GroupColumnIO) {
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            parquetColumn = this.convertGroupField(groupColumnIO, sparkReadType);
        } else {
            throw new MatchError((Object)columnIO);
        }
        return parquetColumn;
    }

    public Option<DataType> convertField$default$2() {
        return None$.MODULE$;
    }

    private ParquetColumn convertPrimitiveField(PrimitiveColumnIO primitiveColumn, Option<DataType> sparkReadType) {
        PrimitiveType parquetType = primitiveColumn.getType().asPrimitiveType();
        LogicalTypeAnnotation typeAnnotation = primitiveColumn.getType().getLogicalTypeAnnotation();
        PrimitiveType.PrimitiveTypeName typeName = primitiveColumn.getPrimitive();
        DataType sparkType = (DataType)sparkReadType.getOrElse(() -> ParquetToSparkSchemaConverter.$anonfun$convertPrimitiveField$2(this, typeName, typeAnnotation, parquetType));
        return ParquetColumn$.MODULE$.apply(sparkType, primitiveColumn);
    }

    private Option<DataType> convertPrimitiveField$default$2() {
        return None$.MODULE$;
    }

    private ParquetColumn convertGroupField(GroupColumnIO groupColumn, Option<DataType> sparkReadType) {
        GroupType field = groupColumn.getType().asGroupType();
        return (ParquetColumn)Option$.MODULE$.apply((Object)field.getLogicalTypeAnnotation()).fold((Function0 & Serializable & scala.Serializable)() -> this.convertInternal(groupColumn, (Option<StructType>)sparkReadType.map((Function1 & Serializable & scala.Serializable)x$5 -> (StructType)x$5)), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ParquetColumn parquetColumn;
            LogicalTypeAnnotation logicalTypeAnnotation = x0$1;
            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.ListLogicalTypeAnnotation) {
                ParquetColumn parquetColumn2;
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> field.getFieldCount() == 1, new StringBuilder(18).append("Invalid list type ").append(field).toString());
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> sparkReadType.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ParquetToSparkSchemaConverter.$anonfun$convertGroupField$6(x$6))), new StringBuilder(61).append("Invalid Spark read type: expected ").append(field).append(" to be list type but found ").append(sparkReadType).toString());
                ColumnIO repeated = groupColumn.getChild(0);
                Type repeatedType = repeated.getType();
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> repeatedType.isRepetition(Type.Repetition.REPEATED), new StringBuilder(18).append("Invalid list type ").append(field).toString());
                Option sparkReadElementType = sparkReadType.map((Function1 & Serializable & scala.Serializable)x$7 -> ((ArrayType)x$7).elementType());
                if (this.isElementType(repeatedType, field.getName())) {
                    ObjectRef converted = ObjectRef.create((Object)this.convertField(repeated, (Option<DataType>)sparkReadElementType));
                    DataType convertedType = (DataType)sparkReadElementType.getOrElse((Function0 & Serializable & scala.Serializable)() -> ((ParquetColumn)converted$1.elem).sparkType());
                    if (repeatedType.isPrimitive()) {
                        ParquetColumn qual$1 = (ParquetColumn)converted.elem;
                        boolean x$1 = true;
                        DataType x$2 = qual$1.copy$default$1();
                        Option<ColumnDescriptor> x$3 = qual$1.copy$default$2();
                        int x$4 = qual$1.copy$default$3();
                        int x$5 = qual$1.copy$default$4();
                        Seq<String> x$6 = qual$1.copy$default$6();
                        Seq<ParquetColumn> x$72 = qual$1.copy$default$7();
                        converted.elem = qual$1.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$72);
                    }
                    parquetColumn2 = ParquetColumn$.MODULE$.apply((DataType)new ArrayType(convertedType, false), groupColumn, (Seq<ParquetColumn>)((Seq)new .colon.colon((Object)((ParquetColumn)converted.elem), (List)Nil$.MODULE$)));
                } else {
                    ColumnIO element = ((GroupColumnIO)repeated).getChild(0);
                    ParquetColumn converted = this.convertField(element, (Option<DataType>)sparkReadElementType);
                    DataType convertedType = (DataType)sparkReadElementType.getOrElse((Function0 & Serializable & scala.Serializable)() -> converted.sparkType());
                    boolean optional = element.getType().isRepetition(Type.Repetition.OPTIONAL);
                    parquetColumn2 = ParquetColumn$.MODULE$.apply((DataType)new ArrayType(convertedType, optional), groupColumn, (Seq<ParquetColumn>)((Seq)new .colon.colon((Object)converted, (List)Nil$.MODULE$)));
                }
                parquetColumn = parquetColumn2;
            } else {
                boolean bl = logicalTypeAnnotation instanceof LogicalTypeAnnotation.MapLogicalTypeAnnotation ? true : logicalTypeAnnotation instanceof LogicalTypeAnnotation.MapKeyValueTypeAnnotation;
                if (bl) {
                    ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> field.getFieldCount() == 1 && !field.getType(0).isPrimitive(), new StringBuilder(18).append("Invalid map type: ").append(field).toString());
                    ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> sparkReadType.forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ParquetToSparkSchemaConverter.$anonfun$convertGroupField$13(x$8))), new StringBuilder(60).append("Invalid Spark read type: expected ").append(field).append(" to be map type but found ").append(sparkReadType).toString());
                    GroupColumnIO keyValue = (GroupColumnIO)groupColumn.getChild(0);
                    GroupType keyValueType = keyValue.getType().asGroupType();
                    ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> keyValueType.isRepetition(Type.Repetition.REPEATED) && keyValueType.getFieldCount() == 2, new StringBuilder(18).append("Invalid map type: ").append(field).toString());
                    ColumnIO key = keyValue.getChild(0);
                    ColumnIO value = keyValue.getChild(1);
                    Option sparkReadKeyType = sparkReadType.map((Function1 & Serializable & scala.Serializable)x$9 -> ((MapType)x$9).keyType());
                    Option sparkReadValueType = sparkReadType.map((Function1 & Serializable & scala.Serializable)x$10 -> ((MapType)x$10).valueType());
                    ParquetColumn convertedKey = this.convertField(key, (Option<DataType>)sparkReadKeyType);
                    ParquetColumn convertedValue = this.convertField(value, (Option<DataType>)sparkReadValueType);
                    DataType convertedKeyType = (DataType)sparkReadKeyType.getOrElse((Function0 & Serializable & scala.Serializable)() -> convertedKey.sparkType());
                    DataType convertedValueType = (DataType)sparkReadValueType.getOrElse((Function0 & Serializable & scala.Serializable)() -> convertedValue.sparkType());
                    boolean valueOptional = value.getType().isRepetition(Type.Repetition.OPTIONAL);
                    parquetColumn = ParquetColumn$.MODULE$.apply((DataType)new MapType(convertedKeyType, convertedValueType, valueOptional), groupColumn, (Seq<ParquetColumn>)((Seq)new .colon.colon((Object)convertedKey, (List)new .colon.colon((Object)convertedValue, (List)Nil$.MODULE$))));
                } else {
                    throw QueryCompilationErrors$.MODULE$.unrecognizedParquetTypeError(field.toString());
                }
            }
            return parquetColumn;
        });
    }

    private Option<DataType> convertGroupField$default$2() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isElementType(Type repeatedType, String parentName) {
        if (repeatedType.isPrimitive()) return true;
        if (repeatedType.asGroupType().getFieldCount() > 1) return true;
        String string = repeatedType.getName();
        String string2 = "array";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = repeatedType.getName();
        String string4 = new StringBuilder(6).append(parentName).append("_tuple").toString();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ Tuple2 $anonfun$convertInternal$3(ParquetToSparkSchemaConverter $this, GroupColumnIO groupColumn$1, Option schemaMapOpt$1, int i) {
        Tuple2 tuple2;
        ColumnIO field = groupColumn$1.getChild(i);
        Option fieldFromReadSchema = schemaMapOpt$1.flatMap((Function1 & Serializable & scala.Serializable)schemaMap -> schemaMap.get((Object)$this.normalizeFieldName(field.getName())));
        Option fieldReadType = fieldFromReadSchema.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType());
        Type.Repetition repetition = field.getType().getRepetition();
        Type.Repetition repetition2 = Type.Repetition.REPEATED;
        if (!(repetition != null ? !repetition.equals(repetition2) : repetition2 != null)) {
            fieldReadType = fieldReadType.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DataType dataType = x0$1;
                if (!(dataType instanceof ArrayType)) {
                    throw QueryCompilationErrors$.MODULE$.illegalParquetTypeError(groupColumn$1.toString());
                }
                ArrayType arrayType = (ArrayType)dataType;
                Some some = new Some((Object)arrayType.elementType());
                return some;
            });
        }
        ParquetColumn convertedField = $this.convertField(field, (Option<DataType>)fieldReadType);
        String fieldName = (String)fieldFromReadSchema.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name()).getOrElse((Function0 & Serializable & scala.Serializable)() -> field.getType().getName());
        Type.Repetition repetition3 = field.getType().getRepetition();
        boolean bl = Type.Repetition.OPTIONAL.equals(repetition3) ? true : Type.Repetition.REQUIRED.equals(repetition3);
        if (bl) {
            Type.Repetition repetition4 = field.getType().getRepetition();
            Type.Repetition repetition5 = Type.Repetition.OPTIONAL;
            boolean nullable = !(repetition4 != null ? !repetition4.equals(repetition5) : repetition5 != null);
            tuple2 = new Tuple2((Object)new StructField(fieldName, convertedField.sparkType(), nullable, StructField$.MODULE$.apply$default$4()), (Object)convertedField);
        } else if (Type.Repetition.REPEATED.equals(repetition3)) {
            ArrayType arrayType = new ArrayType(convertedField.sparkType(), false);
            boolean x$12 = true;
            DataType x$22 = convertedField.copy$default$1();
            Option<ColumnDescriptor> x$3 = convertedField.copy$default$2();
            int x$4 = convertedField.copy$default$3();
            int x$5 = convertedField.copy$default$4();
            Seq<String> x$6 = convertedField.copy$default$6();
            Seq<ParquetColumn> x$7 = convertedField.copy$default$7();
            tuple2 = new Tuple2((Object)new StructField(fieldName, (DataType)arrayType, false, StructField$.MODULE$.apply$default$4()), (Object)new ParquetColumn((DataType)arrayType, (Option<ColumnDescriptor>)None$.MODULE$, convertedField.repetitionLevel() - 1, convertedField.definitionLevel() - 1, true, convertedField.path(), (Seq<ParquetColumn>)((Seq)new .colon.colon((Object)convertedField.copy(x$22, x$3, x$4, x$5, x$12, x$6, x$7), (List)Nil$.MODULE$))));
        } else {
            throw new MatchError((Object)repetition3);
        }
        return tuple2;
    }

    private static final String typeString$1(LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        return typeAnnotation$1 == null ? String.valueOf(typeName$1) : new StringBuilder(3).append(typeName$1).append(" (").append(typeAnnotation$1).append(")").toString();
    }

    private static final Nothing$ typeNotImplemented$1(LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw QueryCompilationErrors$.MODULE$.parquetTypeUnsupportedYetError(ParquetToSparkSchemaConverter.typeString$1(typeAnnotation$1, typeName$1));
    }

    private static final Nothing$ illegalType$1(LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw QueryCompilationErrors$.MODULE$.illegalParquetTypeError(ParquetToSparkSchemaConverter.typeString$1(typeAnnotation$1, typeName$1));
    }

    private static final DecimalType makeDecimalType$1(int maxPrecision, LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalTypeAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)typeAnnotation$1;
        int precision = decimalLogicalTypeAnnotation.getPrecision();
        int scale = decimalLogicalTypeAnnotation.getScale();
        ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> maxPrecision == -1 || 1 <= precision && precision <= maxPrecision, new StringBuilder(55).append("Invalid decimal precision: ").append(typeName$1).append(" cannot store ").append(precision).append(" digits (max ").append(maxPrecision).append(")").toString());
        return new DecimalType(precision, scale);
    }

    private static final int makeDecimalType$default$1$1() {
        return -1;
    }

    public static final /* synthetic */ boolean $anonfun$convertPrimitiveField$3(ParquetToSparkSchemaConverter $this) {
        return $this.assumeInt96IsTimestamp;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ AtomicType $anonfun$convertPrimitiveField$2(ParquetToSparkSchemaConverter $this, PrimitiveType.PrimitiveTypeName typeName$1, LogicalTypeAnnotation typeAnnotation$1, PrimitiveType parquetType$1) {
        block43: {
            block56: {
                block58: {
                    block57: {
                        block55: {
                            block47: {
                                block49: {
                                    block53: {
                                        block54: {
                                            block52: {
                                                block51: {
                                                    block50: {
                                                        block48: {
                                                            block46: {
                                                                block45: {
                                                                    block44: {
                                                                        block42: {
                                                                            var10_4 = typeName$1;
                                                                            if (!PrimitiveType.PrimitiveTypeName.BOOLEAN.equals(var10_4)) break block42;
                                                                            var4_5 = BooleanType$.MODULE$;
                                                                            break block43;
                                                                        }
                                                                        if (!PrimitiveType.PrimitiveTypeName.FLOAT.equals(var10_4)) break block44;
                                                                        var4_5 = FloatType$.MODULE$;
                                                                        break block43;
                                                                    }
                                                                    if (!PrimitiveType.PrimitiveTypeName.DOUBLE.equals(var10_4)) break block45;
                                                                    var4_5 = DoubleType$.MODULE$;
                                                                    break block43;
                                                                }
                                                                if (!PrimitiveType.PrimitiveTypeName.INT32.equals(var10_4)) break block46;
                                                                var11_6 = false;
                                                                var12_7 = null;
                                                                var13_8 = typeAnnotation$1;
                                                                if (!(var13_8 instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation)) ** GOTO lbl-1000
                                                                var11_6 = true;
                                                                var12_7 = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)var13_8;
                                                                if (var12_7.isSigned()) {
                                                                    var14_9 = var12_7.getBitWidth();
                                                                    switch (var14_9) {
                                                                        case 8: {
                                                                            v0 = ByteType$.MODULE$;
                                                                            break;
                                                                        }
                                                                        case 16: {
                                                                            v0 = ShortType$.MODULE$;
                                                                            break;
                                                                        }
                                                                        case 32: {
                                                                            v0 = IntegerType$.MODULE$;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation$1, typeName$1);
                                                                        }
                                                                    }
                                                                    var9_10 = v0;
                                                                } else if (var13_8 == null) {
                                                                    var9_10 = IntegerType$.MODULE$;
                                                                } else if (var13_8 instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
                                                                    var9_10 = DateType$.MODULE$;
                                                                } else if (var13_8 instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                                                                    var9_10 = ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_INT_DIGITS(), typeAnnotation$1, typeName$1);
                                                                } else if (var11_6 && !var12_7.isSigned()) {
                                                                    var15_11 = var12_7.getBitWidth();
                                                                    switch (var15_11) {
                                                                        case 8: {
                                                                            v1 = ShortType$.MODULE$;
                                                                            break;
                                                                        }
                                                                        case 16: {
                                                                            v1 = IntegerType$.MODULE$;
                                                                            break;
                                                                        }
                                                                        case 32: {
                                                                            v1 = LongType$.MODULE$;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation$1, typeName$1);
                                                                        }
                                                                    }
                                                                    var9_10 = v1;
                                                                } else {
                                                                    if (var13_8 instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
                                                                        var16_12 = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)var13_8;
                                                                        v2 = var16_12.getUnit();
                                                                        var17_13 = LogicalTypeAnnotation.TimeUnit.MILLIS;
                                                                        if (!(v2 != null ? v2.equals(var17_13) == false : var17_13 != null)) {
                                                                            throw ParquetToSparkSchemaConverter.typeNotImplemented$1(typeAnnotation$1, typeName$1);
                                                                        }
                                                                    }
                                                                    throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation$1, typeName$1);
                                                                }
                                                                var4_5 = var9_10;
                                                                break block43;
                                                            }
                                                            if (!PrimitiveType.PrimitiveTypeName.INT64.equals(var10_4)) break block47;
                                                            var18_14 = false;
                                                            var19_15 = null;
                                                            var20_16 = false;
                                                            var21_17 = null;
                                                            var22_18 = typeAnnotation$1;
                                                            if (!(var22_18 instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation)) break block48;
                                                            var18_14 = true;
                                                            var19_15 = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)var22_18;
                                                            if (!var19_15.isSigned()) break block48;
                                                            var23_19 = var19_15.getBitWidth();
                                                            switch (var23_19) {
                                                                case 64: {
                                                                    break;
                                                                }
                                                                default: {
                                                                    throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation$1, typeName$1);
                                                                }
                                                            }
                                                            var8_20 = LongType$.MODULE$;
                                                            break block49;
                                                        }
                                                        if (var22_18 != null) break block50;
                                                        var8_20 = LongType$.MODULE$;
                                                        break block49;
                                                    }
                                                    if (!(var22_18 instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)) break block51;
                                                    var8_20 = ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_LONG_DIGITS(), typeAnnotation$1, typeName$1);
                                                    break block49;
                                                }
                                                if (!var18_14 || var19_15.isSigned()) break block52;
                                                var24_21 = var19_15.getBitWidth();
                                                switch (var24_21) {
                                                    case 64: {
                                                        ** break;
                                                    }
                                                    default: {
                                                        throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation$1, typeName$1);
                                                    }
lbl-1000:
                                                    // 1 sources

                                                    {
                                                        var8_20 = new DecimalType(20, 0);
                                                    }
                                                }
                                                break block49;
                                            }
                                            if (!(var22_18 instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)) break block53;
                                            var20_16 = true;
                                            var21_17 = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)var22_18;
                                            v3 = var21_17.getUnit();
                                            var25_22 = LogicalTypeAnnotation.TimeUnit.MICROS;
                                            if (!(v3 == null ? var25_22 != null : v3.equals(var25_22) == false)) break block54;
                                            v4 = var21_17.getUnit();
                                            var26_23 = LogicalTypeAnnotation.TimeUnit.MILLIS;
                                            if (v4 != null ? v4.equals(var26_23) == false : var26_23 != null) break block53;
                                        }
                                        var8_20 = var21_17.isAdjustedToUTC() != false ? TimestampType$.MODULE$ : (Utils$.MODULE$.isTesting() != false ? TimestampNTZType$.MODULE$ : TimestampType$.MODULE$);
                                        break block49;
                                    }
                                    if (!var20_16) ** GOTO lbl-1000
                                    v5 = var21_17.getUnit();
                                    var27_24 = LogicalTypeAnnotation.TimeUnit.NANOS;
                                    if (!(v5 != null ? v5.equals(var27_24) == false : var27_24 != null) && $this.nanosAsLong) {
                                        var8_20 = LongType$.MODULE$;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation$1, typeName$1);
                                    }
                                }
                                var4_5 = var8_20;
                                break block43;
                            }
                            if (!PrimitiveType.PrimitiveTypeName.INT96.equals(var10_4)) break block55;
                            ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$convertPrimitiveField$3(org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter ), ()Z)((ParquetToSparkSchemaConverter)$this), new StringBuilder(88).append("INT96 is not supported unless it's interpreted as timestamp. ").append("Please try to set ").append(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()).append(" to true.").toString());
                            var4_5 = TimestampType$.MODULE$;
                            break block43;
                        }
                        if (!PrimitiveType.PrimitiveTypeName.BINARY.equals(var10_4)) break block56;
                        var28_25 = false;
                        var29_26 = null;
                        var30_27 = typeAnnotation$1;
                        var7_28 = var30_27 instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation != false ? true : (var30_27 instanceof LogicalTypeAnnotation.EnumLogicalTypeAnnotation != false ? true : var30_27 instanceof LogicalTypeAnnotation.JsonLogicalTypeAnnotation != false);
                        if (!var7_28) break block57;
                        var6_29 = StringType$.MODULE$;
                        break block58;
                    }
                    if (var30_27 != null) ** GOTO lbl-1000
                    var28_25 = true;
                    var29_26 = var30_27;
                    if ($this.assumeBinaryIsString) {
                        var6_29 = StringType$.MODULE$;
                    } else if (var28_25) {
                        var6_29 = BinaryType$.MODULE$;
                    } else if (var30_27 instanceof LogicalTypeAnnotation.BsonLogicalTypeAnnotation) {
                        var6_29 = BinaryType$.MODULE$;
                    } else if (var30_27 instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                        var6_29 = ParquetToSparkSchemaConverter.makeDecimalType$1(ParquetToSparkSchemaConverter.makeDecimalType$default$1$1(), typeAnnotation$1, typeName$1);
                    } else {
                        throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation$1, typeName$1);
                    }
                }
                var4_5 = var6_29;
                break block43;
            }
            if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.equals(var10_4)) {
                var31_30 = typeAnnotation$1;
                if (!(var31_30 instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)) {
                    if (var31_30 instanceof LogicalTypeAnnotation.IntervalLogicalTypeAnnotation) {
                        throw ParquetToSparkSchemaConverter.typeNotImplemented$1(typeAnnotation$1, typeName$1);
                    }
                    throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation$1, typeName$1);
                }
                var5_31 = ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.maxPrecisionForBytes(parquetType$1.getTypeLength()), typeAnnotation$1, typeName$1);
                var4_5 = var5_31;
            } else {
                throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation$1, typeName$1);
            }
        }
        return var4_5;
    }

    public static final /* synthetic */ boolean $anonfun$convertGroupField$6(DataType x$6) {
        return x$6 instanceof ArrayType;
    }

    public static final /* synthetic */ boolean $anonfun$convertGroupField$13(DataType x$8) {
        return x$8 instanceof MapType;
    }

    public ParquetToSparkSchemaConverter(boolean assumeBinaryIsString, boolean assumeInt96IsTimestamp, boolean caseSensitive, boolean nanosAsLong) {
        this.assumeBinaryIsString = assumeBinaryIsString;
        this.assumeInt96IsTimestamp = assumeInt96IsTimestamp;
        this.caseSensitive = caseSensitive;
        this.nanosAsLong = nanosAsLong;
    }

    public ParquetToSparkSchemaConverter(SQLConf conf) {
        this(conf.isParquetBinaryAsString(), conf.isParquetINT96AsTimestamp(), conf.caseSensitiveAnalysis(), conf.legacyParquetNanosAsLong());
    }

    public ParquetToSparkSchemaConverter(Configuration conf) {
        this(new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key()))).toBoolean(), new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()))).toBoolean(), new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.CASE_SENSITIVE().key()))).toBoolean(), new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key()))).toBoolean());
    }
}

