/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import org.apache.hadoop.conf.Configuration;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.util.UnsafeRowUtils$;
import org.apache.spark.sql.execution.streaming.state.InvalidUnsafeRowException;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;

public final class StateStoreProvider$ {
    public static StateStoreProvider$ MODULE$;

    static {
        new StateStoreProvider$();
    }

    public StateStoreProvider create(String providerClassName) {
        Class providerClass = Utils$.MODULE$.classForName(providerClassName, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
        return (StateStoreProvider)providerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public StateStoreProvider createAndInit(StateStoreProviderId providerId, StructType keySchema, StructType valueSchema, int numColsPrefixKey, StateStoreConf storeConf, Configuration hadoopConf) {
        StateStoreProvider provider = this.create(storeConf.providerClass());
        provider.init(providerId.storeId(), keySchema, valueSchema, numColsPrefixKey, storeConf, hadoopConf);
        return provider;
    }

    public void validateStateRowFormat(UnsafeRow keyRow, StructType keySchema, UnsafeRow valueRow, StructType valueSchema, StateStoreConf conf) {
        if (conf.formatValidationEnabled()) {
            if (!UnsafeRowUtils$.MODULE$.validateStructuralIntegrity(keyRow, keySchema)) {
                throw new InvalidUnsafeRowException();
            }
            if (conf.formatValidationCheckValue() && !UnsafeRowUtils$.MODULE$.validateStructuralIntegrity(valueRow, valueSchema)) {
                throw new InvalidUnsafeRowException();
            }
        }
    }

    private StateStoreProvider$() {
        MODULE$ = this;
    }
}

