/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.auth;

import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import org.apache.kyuubi.shade.org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.kyuubi.shade.org.apache.thrift.transport.TSocket;
import org.apache.kyuubi.shade.org.apache.thrift.transport.TTransport;
import org.apache.kyuubi.shade.org.apache.thrift.transport.TTransportException;

public class ThriftUtils {
    public static TTransport getSocketTransport(String host, int port, int connectTimeout, int socketTimeout) {
        return new TSocket(host, port, socketTimeout, connectTimeout);
    }

    public static TTransport getSSLSocket(String host, int port, int connectTimeout, int socketTimeout) throws TTransportException {
        TSocket tSSLSocket = TSSLTransportFactory.getClientSocket(host, port, socketTimeout);
        tSSLSocket.setConnectTimeout(connectTimeout);
        return ThriftUtils.getSSLSocketWithHttps(tSSLSocket);
    }

    public static TTransport getSSLSocket(String host, int port, int connectTimeout, int socketTimeout, String trustStorePath, String trustStorePassWord) throws TTransportException {
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
        params.setTrustStore(trustStorePath, trustStorePassWord);
        params.requireClientAuth(true);
        TSocket tSSLSocket = TSSLTransportFactory.getClientSocket(host, port, socketTimeout, params);
        tSSLSocket.setConnectTimeout(connectTimeout);
        return ThriftUtils.getSSLSocketWithHttps(tSSLSocket);
    }

    private static TSocket getSSLSocketWithHttps(TSocket tSSLSocket) throws TTransportException {
        SSLSocket sslSocket = (SSLSocket)tSSLSocket.getSocket();
        SSLParameters sslParams = sslSocket.getSSLParameters();
        sslParams.setEndpointIdentificationAlgorithm("HTTPS");
        sslSocket.setSSLParameters(sslParams);
        return new TSocket(sslSocket);
    }
}

