/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.fluss.cluster.rebalance;

import org.apache.fluss.metadata.TableBucket;

import java.util.Map;

/**
 * The rebalance plan.
 *
 * @since 0.9
 */
public class RebalancePlan {

    private final String rebalanceId;
    private final Map<TableBucket, RebalancePlanForBucket> planForBucketMap;

    public RebalancePlan(
            String rebalanceId, Map<TableBucket, RebalancePlanForBucket> planForBucketMap) {
        this.rebalanceId = rebalanceId;
        this.planForBucketMap = planForBucketMap;
    }

    public String getRebalanceId() {
        return rebalanceId;
    }

    public Map<TableBucket, RebalancePlanForBucket> getPlanForBucketMap() {
        return planForBucketMap;
    }
}
