/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.data.jmap;

import jakarta.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.task.Task;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.webadmin.data.jmap.Constants;
import org.apache.james.webadmin.data.jmap.MessageFastViewProjectionCorrector;
import org.apache.james.webadmin.data.jmap.RecomputeUserFastViewProjectionItemsTask;
import org.apache.james.webadmin.data.jmap.RunningOptionsParser;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.utils.ErrorResponder;
import spark.Request;

public class RecomputeUserFastViewProjectionItemsRequestToTask
extends TaskFromRequestRegistry.TaskRegistration {
    @Inject
    RecomputeUserFastViewProjectionItemsRequestToTask(MessageFastViewProjectionCorrector corrector, UsersRepository usersRepository) {
        super(Constants.TASK_REGISTRATION_KEY, request -> RecomputeUserFastViewProjectionItemsRequestToTask.toTask(corrector, usersRepository, request));
    }

    private static Task toTask(MessageFastViewProjectionCorrector corrector, UsersRepository usersRepository, Request request) throws UsersRepositoryException {
        Username username = Username.of((String)request.params("username"));
        if (usersRepository.contains(username)) {
            return new RecomputeUserFastViewProjectionItemsTask(corrector, RunningOptionsParser.parse(request), username);
        }
        throw ErrorResponder.builder().type(ErrorResponder.ErrorType.NOT_FOUND).statusCode(404).message("User '" + username.asString() + "' does not exists").haltError();
    }
}

