/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import javax.mail.Flags;
import org.apache.james.mailbox.FlagsBuilder;

public class ApplicableFlagBuilder {
    @VisibleForTesting
    static final Flags DEFAULT_APPLICABLE_FLAGS = FlagsBuilder.builder().add(Flags.Flag.ANSWERED, Flags.Flag.DELETED, Flags.Flag.DRAFT, Flags.Flag.FLAGGED, Flags.Flag.SEEN).build();
    private final FlagsBuilder builder = FlagsBuilder.builder().add(DEFAULT_APPLICABLE_FLAGS);

    public static ApplicableFlagBuilder builder() {
        return new ApplicableFlagBuilder();
    }

    public static ApplicableFlagBuilder from(Flags ... flags) {
        return new ApplicableFlagBuilder().add(flags);
    }

    public static ApplicableFlagBuilder from(String ... flags) {
        return new ApplicableFlagBuilder().add(flags);
    }

    private ApplicableFlagBuilder() {
    }

    public ApplicableFlagBuilder add(String ... flags) {
        this.builder.add(flags);
        return this;
    }

    public ApplicableFlagBuilder add(Flags ... flags) {
        this.builder.add(flags);
        return this;
    }

    public ApplicableFlagBuilder add(List<Flags> flags) {
        this.builder.add(flags);
        return this;
    }

    public Flags build() {
        Flags flags = this.builder.build();
        flags.remove(Flags.Flag.RECENT);
        flags.remove(Flags.Flag.USER);
        return flags;
    }
}

