/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ArgumentListArgument
extends Argument {
    private static final long serialVersionUID = 1926330851837348378L;
    @NotNull
    private final ArgumentParser parser;
    @NotNull
    private final List<ArgumentParser> values;
    @NotNull
    private final List<String> valueStrings;

    public ArgumentListArgument(@Nullable Character shortIdentifier, @Nullable String longIdentifier, @NotNull String description, @NotNull ArgumentParser parser) throws ArgumentException {
        this(shortIdentifier, longIdentifier, false, 1, null, description, parser);
    }

    public ArgumentListArgument(@Nullable Character shortIdentifier, @Nullable String longIdentifier, boolean isRequired, int maxOccurrences, @Nullable String valuePlaceholder, @NotNull String description, @NotNull ArgumentParser parser) throws ArgumentException {
        super(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder == null ? ArgsMessages.INFO_PLACEHOLDER_ARGS.get() : valuePlaceholder, description);
        this.parser = parser.getCleanCopy();
        this.values = new ArrayList<ArgumentParser>(10);
        this.valueStrings = new ArrayList<String>(10);
    }

    private ArgumentListArgument(@NotNull ArgumentListArgument source) {
        super(source);
        this.parser = source.parser;
        this.values = new ArrayList<ArgumentParser>(10);
        this.valueStrings = new ArrayList<String>(10);
    }

    @NotNull
    public ArgumentParser getCleanParser() {
        return this.parser.getCleanCopy();
    }

    @Override
    protected void addValue(@NotNull String valueString) throws ArgumentException {
        List<String> argList;
        try {
            argList = StaticUtils.toArgumentList(valueString);
        }
        catch (ParseException pe) {
            Debug.debugException(pe);
            throw new ArgumentException(ArgsMessages.ERR_ARG_LIST_MALFORMED_VALUE.get(valueString, this.getIdentifierString(), pe.getMessage()), pe);
        }
        String[] args = new String[argList.size()];
        argList.toArray(args);
        ArgumentParser p = this.parser.getCleanCopy();
        try {
            p.parse(args);
        }
        catch (ArgumentException ae) {
            Debug.debugException(ae);
            throw new ArgumentException(ArgsMessages.ERR_ARG_LIST_INVALID_VALUE.get(valueString, this.getIdentifierString(), ae.getMessage()), ae);
        }
        this.values.add(p);
        this.valueStrings.add(valueString);
    }

    @NotNull
    public List<ArgumentParser> getValueParsers() {
        return Collections.unmodifiableList(this.values);
    }

    @NotNull
    public List<String> getValueStrings() {
        return Collections.unmodifiableList(this.valueStrings);
    }

    @Override
    @NotNull
    public List<String> getValueStringRepresentations(boolean useDefault) {
        return Collections.unmodifiableList(this.valueStrings);
    }

    @Override
    protected boolean hasDefaultValue() {
        return false;
    }

    @Override
    @NotNull
    public String getDataTypeName() {
        return ArgsMessages.INFO_ARG_LIST_TYPE_NAME.get();
    }

    @Override
    @NotNull
    public String getValueConstraints() {
        return ArgsMessages.INFO_ARG_LIST_CONSTRAINTS.get();
    }

    @Override
    protected void reset() {
        super.reset();
        this.values.clear();
    }

    @Override
    @NotNull
    public ArgumentListArgument getCleanCopy() {
        return new ArgumentListArgument(this);
    }

    @Override
    protected void addToCommandLine(@NotNull List<String> argStrings) {
        for (String s : this.valueStrings) {
            argStrings.add(this.getIdentifierString());
            if (this.isSensitive()) {
                argStrings.add("***REDACTED***");
                continue;
            }
            argStrings.add(s);
        }
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ArgumentListArgument(");
        this.appendBasicToStringInfo(buffer);
        buffer.append(", parser=");
        this.parser.toString(buffer);
        buffer.append(')');
    }
}

