/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.asn1.ASN1BitString;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1ObjectIdentifier;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.util.Base64;
import com.unboundid.util.CryptoHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.OID;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.CertMessages;
import com.unboundid.util.ssl.cert.DecodedPrivateKey;
import com.unboundid.util.ssl.cert.EllipticCurvePrivateKey;
import com.unboundid.util.ssl.cert.NamedCurve;
import com.unboundid.util.ssl.cert.PKCS8PrivateKeyVersion;
import com.unboundid.util.ssl.cert.PublicKeyAlgorithmIdentifier;
import com.unboundid.util.ssl.cert.RSAPrivateKey;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PKCS8PrivateKey
implements Serializable {
    private static final byte TYPE_ATTRIBUTES = -96;
    private static final byte TYPE_PUBLIC_KEY = -127;
    private static final long serialVersionUID = -5551171525811450486L;
    @Nullable
    private final ASN1BitString publicKey;
    @Nullable
    private final ASN1Element attributesElement;
    @Nullable
    private final ASN1Element privateKeyAlgorithmParameters;
    @NotNull
    private final ASN1OctetString encodedPrivateKey;
    @NotNull
    private final byte[] pkcs8PrivateKeyBytes;
    @Nullable
    private final DecodedPrivateKey decodedPrivateKey;
    @NotNull
    private final OID privateKeyAlgorithmOID;
    @NotNull
    private final PKCS8PrivateKeyVersion version;
    @Nullable
    private final String privateKeyAlgorithmName;

    PKCS8PrivateKey(@NotNull PKCS8PrivateKeyVersion version, @NotNull OID privateKeyAlgorithmOID, @Nullable ASN1Element privateKeyAlgorithmParameters, @NotNull ASN1OctetString encodedPrivateKey, @Nullable DecodedPrivateKey decodedPrivateKey, @Nullable ASN1Element attributesElement, @Nullable ASN1BitString publicKey) throws CertException {
        this.version = version;
        this.privateKeyAlgorithmOID = privateKeyAlgorithmOID;
        this.privateKeyAlgorithmParameters = privateKeyAlgorithmParameters;
        this.encodedPrivateKey = encodedPrivateKey;
        this.decodedPrivateKey = decodedPrivateKey;
        this.attributesElement = attributesElement;
        this.publicKey = publicKey;
        PublicKeyAlgorithmIdentifier identifier = PublicKeyAlgorithmIdentifier.forOID(privateKeyAlgorithmOID);
        this.privateKeyAlgorithmName = identifier == null ? null : identifier.getName();
        this.pkcs8PrivateKeyBytes = this.encode().encode();
    }

    public PKCS8PrivateKey(@NotNull byte[] privateKeyBytes) throws CertException {
        Serializable pk;
        ASN1Element[] privateKeyElements;
        this.pkcs8PrivateKeyBytes = privateKeyBytes;
        try {
            privateKeyElements = ASN1Sequence.decodeAsSequence(privateKeyBytes).elements();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_PRIVATE_KEY_DECODE_NOT_SEQUENCE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        if (privateKeyElements.length < 3) {
            throw new CertException(CertMessages.ERR_PRIVATE_KEY_DECODE_NOT_ENOUGH_ELEMENTS.get(privateKeyElements.length));
        }
        try {
            int versionIntValue = privateKeyElements[0].decodeAsInteger().intValue();
            this.version = PKCS8PrivateKeyVersion.valueOf(versionIntValue);
            if (this.version == null) {
                throw new CertException(CertMessages.ERR_PRIVATE_KEY_DECODE_UNSUPPORTED_VERSION.get(versionIntValue));
            }
        }
        catch (CertException e) {
            Debug.debugException(e);
            throw e;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_PRIVATE_KEY_DECODE_CANNOT_PARSE_VERSION.get(StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            ASN1Element[] privateKeyAlgorithmElements = privateKeyElements[1].decodeAsSequence().elements();
            this.privateKeyAlgorithmOID = privateKeyAlgorithmElements[0].decodeAsObjectIdentifier().getOID();
            this.privateKeyAlgorithmParameters = privateKeyAlgorithmElements.length > 1 ? privateKeyAlgorithmElements[1] : null;
            this.encodedPrivateKey = privateKeyElements[2].decodeAsOctetString();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_PRIVATE_KEY_DECODE_CANNOT_PARSE_ALGORITHM.get(StaticUtils.getExceptionMessage(e)), e);
        }
        PublicKeyAlgorithmIdentifier privateKeyAlgorithmIdentifier = PublicKeyAlgorithmIdentifier.forOID(this.privateKeyAlgorithmOID);
        if (privateKeyAlgorithmIdentifier == null) {
            this.privateKeyAlgorithmName = null;
            this.decodedPrivateKey = null;
        } else {
            this.privateKeyAlgorithmName = privateKeyAlgorithmIdentifier.getName();
            pk = null;
            switch (privateKeyAlgorithmIdentifier) {
                case RSA: {
                    try {
                        pk = new RSAPrivateKey(this.encodedPrivateKey);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                    break;
                }
                case EC: {
                    try {
                        pk = new EllipticCurvePrivateKey(this.encodedPrivateKey);
                        break;
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                }
            }
            this.decodedPrivateKey = pk;
        }
        pk = null;
        ASN1Element attrsElement = null;
        block21: for (int i = 3; i < privateKeyElements.length; ++i) {
            ASN1Element element = privateKeyElements[i];
            switch (element.getType()) {
                case -96: {
                    attrsElement = element;
                    continue block21;
                }
                case -127: {
                    try {
                        pk = ASN1BitString.decodeAsBitString(element);
                        continue block21;
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new CertException(CertMessages.ERR_PRIVATE_KEY_DECODE_CANNOT_PARSE_PUBLIC_KEY.get(StaticUtils.getExceptionMessage(e)), e);
                    }
                }
            }
        }
        this.attributesElement = attrsElement;
        this.publicKey = pk;
    }

    @NotNull
    static byte[] wrapRSAPrivateKey(@NotNull byte[] rsaPrivateKeyBytes) throws CertException {
        try {
            ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(5);
            elements.add(new ASN1Integer(PKCS8PrivateKeyVersion.V1.getIntValue()));
            elements.add(new ASN1Sequence(new ASN1ObjectIdentifier(PublicKeyAlgorithmIdentifier.RSA.getOID())));
            elements.add(new ASN1OctetString(rsaPrivateKeyBytes));
            return new ASN1Sequence(elements).encode();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_PRIVATE_KEY_WRAP_RSA_KEY_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    ASN1Element encode() throws CertException {
        try {
            ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(5);
            elements.add(new ASN1Integer(this.version.getIntValue()));
            if (this.privateKeyAlgorithmParameters == null) {
                elements.add(new ASN1Sequence(new ASN1ObjectIdentifier(this.privateKeyAlgorithmOID)));
            } else {
                elements.add(new ASN1Sequence(new ASN1ObjectIdentifier(this.privateKeyAlgorithmOID), this.privateKeyAlgorithmParameters));
            }
            elements.add(this.encodedPrivateKey);
            if (this.attributesElement != null) {
                elements.add(new ASN1Element(-96, this.attributesElement.getValue()));
            }
            if (this.publicKey != null) {
                elements.add(new ASN1BitString(-127, this.publicKey.getBits()));
            }
            return new ASN1Sequence(elements);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_PRIVATE_KEY_ENCODE_ERROR.get(this.toString(), StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public byte[] getPKCS8PrivateKeyBytes() {
        return this.pkcs8PrivateKeyBytes;
    }

    @NotNull
    public PKCS8PrivateKeyVersion getVersion() {
        return this.version;
    }

    @NotNull
    public OID getPrivateKeyAlgorithmOID() {
        return this.privateKeyAlgorithmOID;
    }

    @Nullable
    public String getPrivateKeyAlgorithmName() {
        return this.privateKeyAlgorithmName;
    }

    @NotNull
    public String getPrivateKeyAlgorithmNameOrOID() {
        if (this.privateKeyAlgorithmName == null) {
            return this.privateKeyAlgorithmOID.toString();
        }
        return this.privateKeyAlgorithmName;
    }

    @Nullable
    public ASN1Element getPrivateKeyAlgorithmParameters() {
        return this.privateKeyAlgorithmParameters;
    }

    @NotNull
    public ASN1OctetString getEncodedPrivateKey() {
        return this.encodedPrivateKey;
    }

    @Nullable
    public DecodedPrivateKey getDecodedPrivateKey() {
        return this.decodedPrivateKey;
    }

    @Nullable
    public ASN1Element getAttributesElement() {
        return this.attributesElement;
    }

    @Nullable
    public ASN1BitString getPublicKey() {
        return this.publicKey;
    }

    @NotNull
    public PrivateKey toPrivateKey() throws GeneralSecurityException {
        KeyFactory keyFactory = CryptoHelper.getKeyFactory(this.getPrivateKeyAlgorithmNameOrOID());
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(this.pkcs8PrivateKeyBytes));
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("PKCS8PrivateKey(version='");
        buffer.append(this.version.getName());
        buffer.append("', privateKeyAlgorithmOID=");
        buffer.append(this.privateKeyAlgorithmOID.toString());
        buffer.append('\'');
        if (this.privateKeyAlgorithmName != null) {
            buffer.append(", privateKeyAlgorithmName='");
            buffer.append(this.privateKeyAlgorithmName);
            buffer.append('\'');
        }
        if (this.decodedPrivateKey == null) {
            buffer.append(", encodedPrivateKey='");
            StaticUtils.toHex(this.encodedPrivateKey.getValue(), ":", buffer);
            buffer.append('\'');
        } else {
            buffer.append(", decodedPrivateKey=");
            this.decodedPrivateKey.toString(buffer);
            if (this.decodedPrivateKey instanceof EllipticCurvePrivateKey) {
                try {
                    OID namedCurveOID = this.privateKeyAlgorithmParameters.decodeAsObjectIdentifier().getOID();
                    buffer.append(", ellipticCurvePrivateKeyParameters=namedCurve='");
                    buffer.append(NamedCurve.getNameOrOID(namedCurveOID));
                    buffer.append('\'');
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        buffer.append("')");
    }

    @NotNull
    public List<String> toPEM() {
        ArrayList<String> lines = new ArrayList<String>(10);
        lines.add("-----BEGIN PRIVATE KEY-----");
        String keyBase64 = Base64.encode(this.pkcs8PrivateKeyBytes);
        lines.addAll(StaticUtils.wrapLine(keyBase64, 64));
        lines.add("-----END PRIVATE KEY-----");
        return Collections.unmodifiableList(lines);
    }

    @NotNull
    public String toPEMString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("-----BEGIN PRIVATE KEY-----");
        buffer.append(StaticUtils.EOL);
        String keyBase64 = Base64.encode(this.pkcs8PrivateKeyBytes);
        for (String line : StaticUtils.wrapLine(keyBase64, 64)) {
            buffer.append(line);
            buffer.append(StaticUtils.EOL);
        }
        buffer.append("-----END PRIVATE KEY-----");
        buffer.append(StaticUtils.EOL);
        return buffer.toString();
    }
}

