/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.google.common.base.Preconditions;
import com.google.common.math.LongMath;

public class Size {
    public static final String UNKNOWN = "UNKNOWN";
    public static final String UNLIMITED = "UNLIMITED";
    public static final long UNKNOWN_VALUE = Long.MIN_VALUE;
    public static final long UNLIMITED_VALUE = -1L;
    private static final long base = 1024L;
    Unit unit;
    Long value;

    private Size(Unit unit, Long value) {
        this.unit = unit;
        this.value = value;
    }

    public static Size parse(String providedLongWithUnitString) {
        return Size.parse(providedLongWithUnitString, Unit.NoUnit);
    }

    public static Size parse(String providedLongWithUnitString, Unit defaultUnit) {
        if (providedLongWithUnitString.equalsIgnoreCase(UNKNOWN)) {
            return new Size(Unit.NoUnit, Long.MIN_VALUE);
        }
        if (providedLongWithUnitString.equalsIgnoreCase(UNLIMITED)) {
            return new Size(Unit.NoUnit, -1L);
        }
        char lastChar = providedLongWithUnitString.charAt(providedLongWithUnitString.length() - 1);
        Unit unit = Size.getUnit(lastChar, defaultUnit);
        String argWithoutUnit = Size.removeLastCharIfNeeded(providedLongWithUnitString, lastChar);
        return new Size(unit, Long.parseLong(argWithoutUnit));
    }

    public static Size of(Long value, Unit unit) {
        Preconditions.checkArgument((value >= 0L ? 1 : 0) != 0, (Object)"Maxsize must be positive");
        return new Size(unit, value);
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Long getValue() {
        return this.value;
    }

    public long asBytes() {
        switch (this.unit) {
            case G: {
                return this.value * LongMath.pow((long)1024L, (int)3);
            }
            case M: {
                return this.value * LongMath.pow((long)1024L, (int)2);
            }
            case K: {
                return this.value * LongMath.pow((long)1024L, (int)1);
            }
        }
        return this.value;
    }

    private static String removeLastCharIfNeeded(String providedLongWithUnitString, char lastChar) {
        switch (lastChar) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return providedLongWithUnitString;
            }
        }
        return providedLongWithUnitString.substring(0, providedLongWithUnitString.length() - 1);
    }

    private static Unit getUnit(char lastChar, Unit defaultUnit) {
        switch (lastChar) {
            case 'K': 
            case 'k': {
                return Unit.K;
            }
            case 'M': 
            case 'm': {
                return Unit.M;
            }
            case 'G': 
            case 'g': {
                return Unit.G;
            }
            case 'B': 
            case 'b': {
                return Unit.B;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return defaultUnit;
            }
        }
        throw new IllegalArgumentException("No unit corresponding to char : " + lastChar);
    }

    public static enum Unit {
        NoUnit,
        B,
        K,
        M,
        G;

    }
}

