/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.UniquenessValidationResult;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class UniquenessResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String UNIQUENESS_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.53";
    private static final byte TYPE_UNIQUENESS_ID = -128;
    private static final byte TYPE_PRE_COMMIT_VALIDATION_PASSED = -127;
    private static final byte TYPE_POST_COMMIT_VALIDATION_PASSED = -126;
    private static final byte TYPE_VALIDATION_MESSAGE = -125;
    @NotNull
    private static final String JSON_FIELD_POST_COMMIT_VALIDATION_PASSED = "post-commit-validation-passed";
    @NotNull
    private static final String JSON_FIELD_PRE_COMMIT_VALIDATION_PASSED = "pre-commit-validation-passed";
    @NotNull
    private static final String JSON_FIELD_UNIQUENESS_ID = "uniqueness-id";
    @NotNull
    private static final String JSON_FIELD_VALIDATION_MESSAGE = "validation-message";
    private static final long serialVersionUID = 5090348902351420617L;
    @Nullable
    private final Boolean postCommitValidationPassed;
    @Nullable
    private final Boolean preCommitValidationPassed;
    @NotNull
    private final String uniquenessID;
    @Nullable
    private final String validationMessage;

    UniquenessResponseControl() {
        this.uniquenessID = null;
        this.preCommitValidationPassed = null;
        this.postCommitValidationPassed = null;
        this.validationMessage = null;
    }

    public UniquenessResponseControl(@NotNull String uniquenessID, @Nullable Boolean preCommitValidationPassed, @Nullable Boolean postCommitValidationPassed, @Nullable String validationMessage) {
        super(UNIQUENESS_RESPONSE_OID, false, UniquenessResponseControl.encodeValue(uniquenessID, preCommitValidationPassed, postCommitValidationPassed, validationMessage));
        Validator.ensureNotNull(uniquenessID);
        this.uniquenessID = uniquenessID;
        this.preCommitValidationPassed = preCommitValidationPassed;
        this.postCommitValidationPassed = postCommitValidationPassed;
        this.validationMessage = validationMessage;
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull String uniquenessID, @Nullable Boolean preCommitValidationPassed, @Nullable Boolean postCommitValidationPassed, @Nullable String validationMessage) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(4);
        elements.add(new ASN1OctetString(-128, uniquenessID));
        if (preCommitValidationPassed != null) {
            elements.add(new ASN1Boolean(-127, preCommitValidationPassed));
        }
        if (postCommitValidationPassed != null) {
            elements.add(new ASN1Boolean(-126, postCommitValidationPassed));
        }
        if (validationMessage != null) {
            elements.add(new ASN1OctetString(-125, validationMessage));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public UniquenessResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_RES_DECODE_NO_VALUE.get());
        }
        try {
            String id = null;
            Boolean prePassed = null;
            Boolean postPassed = null;
            String message = null;
            block9: for (ASN1Element e : ASN1Sequence.decodeAsSequence(value.getValue()).elements()) {
                switch (e.getType()) {
                    case -128: {
                        id = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block9;
                    }
                    case -127: {
                        prePassed = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block9;
                    }
                    case -126: {
                        postPassed = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block9;
                    }
                    case -125: {
                        message = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block9;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_RES_DECODE_UNKNOWN_ELEMENT_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
            if (id == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_RES_DECODE_NO_UNIQUENESS_ID.get());
            }
            this.uniquenessID = id;
            this.preCommitValidationPassed = prePassed;
            this.postCommitValidationPassed = postPassed;
            this.validationMessage = message;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_RES_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    @NotNull
    public UniquenessResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new UniquenessResponseControl(oid, isCritical, value);
    }

    @NotNull
    public static Map<String, UniquenessResponseControl> get(@NotNull LDAPResult result) throws LDAPException {
        Control[] responseControls = result.getResponseControls();
        if (responseControls.length == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, UniquenessResponseControl> controlMap = new LinkedHashMap<String, UniquenessResponseControl>(StaticUtils.computeMapCapacity(responseControls.length));
        for (Control c : responseControls) {
            if (!c.getOID().equals(UNIQUENESS_RESPONSE_OID)) continue;
            UniquenessResponseControl urc = c instanceof UniquenessResponseControl ? (UniquenessResponseControl)c : new UniquenessResponseControl().decodeControl(c.getOID(), c.isCritical(), c.getValue());
            String uniquenessID = urc.getUniquenessID();
            if (controlMap.containsKey(uniquenessID)) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_RES_GET_ID_CONFLICT.get(uniquenessID));
            }
            controlMap.put(uniquenessID, urc);
        }
        return Collections.unmodifiableMap(controlMap);
    }

    public boolean uniquenessConflictFound() {
        return this.preCommitValidationPassed == Boolean.FALSE || this.postCommitValidationPassed == Boolean.FALSE;
    }

    @NotNull
    public String getUniquenessID() {
        return this.uniquenessID;
    }

    @NotNull
    public UniquenessValidationResult getPreCommitValidationResult() {
        if (this.preCommitValidationPassed == null) {
            return UniquenessValidationResult.VALIDATION_NOT_ATTEMPTED;
        }
        if (this.preCommitValidationPassed.booleanValue()) {
            return UniquenessValidationResult.VALIDATION_PASSED;
        }
        return UniquenessValidationResult.VALIDATION_FAILED;
    }

    @Nullable
    public Boolean getPreCommitValidationPassed() {
        return this.preCommitValidationPassed;
    }

    @NotNull
    public UniquenessValidationResult getPostCommitValidationResult() {
        if (this.postCommitValidationPassed == null) {
            return UniquenessValidationResult.VALIDATION_NOT_ATTEMPTED;
        }
        if (this.postCommitValidationPassed.booleanValue()) {
            return UniquenessValidationResult.VALIDATION_PASSED;
        }
        return UniquenessValidationResult.VALIDATION_FAILED;
    }

    @Nullable
    public Boolean getPostCommitValidationPassed() {
        return this.postCommitValidationPassed;
    }

    @Nullable
    public String getValidationMessage() {
        return this.validationMessage;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_UNIQUENESS_RES_CONTROL_NAME.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        LinkedHashMap<String, JSONValue> valueFields = new LinkedHashMap<String, JSONValue>();
        valueFields.put(JSON_FIELD_UNIQUENESS_ID, new JSONString(this.uniquenessID));
        if (this.preCommitValidationPassed != null) {
            valueFields.put(JSON_FIELD_PRE_COMMIT_VALIDATION_PASSED, new JSONBoolean(this.preCommitValidationPassed));
        }
        if (this.postCommitValidationPassed != null) {
            valueFields.put(JSON_FIELD_POST_COMMIT_VALIDATION_PASSED, new JSONBoolean(this.postCommitValidationPassed));
        }
        if (this.validationMessage != null) {
            valueFields.put(JSON_FIELD_VALIDATION_MESSAGE, new JSONString(this.validationMessage));
        }
        return new JSONObject(new JSONField("oid", UNIQUENESS_RESPONSE_OID), new JSONField("control-name", ControlMessages.INFO_UNIQUENESS_RES_CONTROL_NAME.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(valueFields)));
    }

    @NotNull
    public static UniquenessResponseControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new UniquenessResponseControl(jsonControl.getOID(), jsonControl.getCriticality(), rawValue);
        }
        JSONObject valueObject = jsonControl.getValueObject();
        String uniquenessID = valueObject.getFieldAsString(JSON_FIELD_UNIQUENESS_ID);
        if (uniquenessID == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_RES_JSON_MISSING_UNIQUENESS_ID.get(controlObject.toSingleLineString(), JSON_FIELD_UNIQUENESS_ID));
        }
        Boolean preCommitValidationPassed = valueObject.getFieldAsBoolean(JSON_FIELD_PRE_COMMIT_VALIDATION_PASSED);
        Boolean postCommitValidationPassed = valueObject.getFieldAsBoolean(JSON_FIELD_POST_COMMIT_VALIDATION_PASSED);
        String validationMessage = valueObject.getFieldAsString(JSON_FIELD_VALIDATION_MESSAGE);
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_UNIQUENESS_ID, JSON_FIELD_PRE_COMMIT_VALIDATION_PASSED, JSON_FIELD_POST_COMMIT_VALIDATION_PASSED, JSON_FIELD_VALIDATION_MESSAGE)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_RES_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new UniquenessResponseControl(uniquenessID, preCommitValidationPassed, postCommitValidationPassed, validationMessage);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("UniquenessResponseControl(uniquenessID='");
        buffer.append(this.uniquenessID);
        buffer.append("', preCommitValidationResult='");
        buffer.append(this.getPreCommitValidationResult().getName());
        buffer.append("', preCommitValidationResult='");
        buffer.append(this.getPostCommitValidationResult().getName());
        buffer.append('\'');
        if (this.validationMessage != null) {
            buffer.append(", validationMessage='");
            buffer.append(this.validationMessage);
            buffer.append('\'');
        }
        buffer.append(')');
    }
}

