/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.io.IOException;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.conf.Compatibility;
import org.apache.openjpa.conf.DetachOptions;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerImpl;
import org.apache.openjpa.kernel.DetachState;
import org.apache.openjpa.kernel.DetachedStateManager;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.OpCallbacks;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.TransferFieldManager;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.util.CallbackException;
import org.apache.openjpa.util.ObjectNotFoundException;
import org.apache.openjpa.util.Proxy;
import org.apache.openjpa.util.ProxyManager;
import org.apache.openjpa.util.UserException;

public class DetachManager
implements DetachState {
    private static Localizer _loc = Localizer.forPackage(DetachManager.class);
    private final BrokerImpl _broker;
    private final boolean _copy;
    private final boolean _full;
    private final ProxyManager _proxy;
    private final DetachOptions _opts;
    private final OpCallbacks _call;
    private final boolean _failFast;
    private boolean _flushed = false;
    private boolean _flushBeforeDetach;
    private boolean _cascadeWithDetach;
    private boolean _reloadOnDetach;
    private final IdentityHashMap _detached;
    private final DetachFieldManager _fullFM;

    static boolean preSerialize(StateManagerImpl sm) {
        ClassMetaData meta;
        if (!sm.isPersistent()) {
            return false;
        }
        if (sm.getBroker().getConfiguration().getCompatibilityInstance().getFlushBeforeDetach()) {
            DetachManager.flushDirty(sm);
        }
        boolean setState = (meta = sm.getMetaData()).getDetachedState() != null && !"`syn".equals(meta.getDetachedState());
        BitSet idxs = setState ? new BitSet(meta.getFields().length) : null;
        DetachManager.preDetach(sm.getBroker(), sm, idxs, false, true);
        if (setState) {
            sm.getPersistenceCapable().pcSetDetachedState(DetachManager.getDetachedState(sm, idxs));
            return false;
        }
        return true;
    }

    static boolean writeDetachedState(StateManagerImpl sm, ObjectOutput out, BitSet idxs) throws IOException {
        if (!sm.isPersistent()) {
            out.writeObject(null);
            out.writeObject(null);
            return false;
        }
        DetachManager.flushDirty(sm);
        BrokerImpl broker = sm.getBroker();
        DetachManager.preDetach(broker, sm, idxs, false, true);
        DetachOptions opts = broker.getConfiguration().getDetachStateInstance();
        if (!opts.getDetachedStateManager() || !DetachManager.useDetachedStateManager(sm, opts)) {
            out.writeObject(DetachManager.getDetachedState(sm, idxs));
            out.writeObject(null);
            return false;
        }
        out.writeObject(null);
        out.writeObject(new DetachedStateManager(sm.getPersistenceCapable(), sm, idxs, opts.getAccessUnloaded(), broker.getMultithreaded()));
        return true;
    }

    private static void preDetach(Broker broker, StateManagerImpl sm, BitSet idxs, boolean full, boolean reloadOnDetach) {
        int detachMode = broker.getDetachState();
        int loadMode = 0;
        BitSet exclude = null;
        if (detachMode == 1) {
            exclude = StoreContext.EXCLUDE_ALL;
        } else if (detachMode == 2) {
            loadMode = 1;
        }
        try {
            if (detachMode != 1 || reloadOnDetach || !reloadOnDetach && !full) {
                sm.load(broker.getFetchConfiguration(), loadMode, exclude, null, false);
            }
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        if (idxs != null) {
            if (detachMode == 0) {
                DetachManager.setFetchGroupFields(broker, sm, idxs);
            } else {
                idxs.or(sm.getLoaded());
            }
            FieldMetaData[] fmds = sm.getMetaData().getFields();
            for (int i = 0; i < fmds.length; ++i) {
                if (!fmds[i].isLRS()) continue;
                idxs.clear(i);
            }
        }
    }

    private static Object getDetachedState(StateManagerImpl sm, BitSet fields) {
        int offset = sm.getMetaData().getIdentityType() == 1 ? 1 : 0;
        Object[] state = sm.isNew() ? new Object[3 + offset] : new Object[2 + offset];
        if (offset > 0) {
            Object id = sm.isEmbedded() || sm.getObjectId() == null ? sm.getId() : sm.getObjectId();
            state[0] = id.toString();
        }
        state[offset] = sm.getVersion();
        state[offset + 1] = fields;
        return state;
    }

    private static boolean flushDirty(StateManagerImpl sm) {
        if (!sm.isDirty() || !sm.getBroker().isActive()) {
            return false;
        }
        BitSet dirtyFields = sm.getDirty();
        BitSet flushedFields = sm.getFlushed();
        for (int i = 0; i < dirtyFields.size(); ++i) {
            if (!dirtyFields.get(i) || flushedFields.get(i)) continue;
            if (sm.getBroker().getRollbackOnly()) {
                sm.getBroker().preFlush();
            } else {
                sm.getBroker().flush();
            }
            return true;
        }
        return false;
    }

    private static void setFetchGroupFields(Broker broker, StateManagerImpl sm, BitSet idxs) {
        FetchConfiguration fetch = broker.getFetchConfiguration();
        FieldMetaData[] fmds = sm.getMetaData().getFields();
        for (int i = 0; i < fmds.length; ++i) {
            if (!fmds[i].isPrimaryKey() && fetch.requiresFetch(fmds[i]) == 0) continue;
            idxs.set(i);
        }
    }

    public DetachManager(BrokerImpl broker, boolean full, OpCallbacks call) {
        this._broker = broker;
        this._proxy = broker.getConfiguration().getProxyManagerInstance();
        this._opts = broker.getConfiguration().getDetachStateInstance();
        this._flushed = full;
        this._call = call;
        this._failFast = (broker.getConfiguration().getMetaDataRepositoryInstance().getMetaDataFactory().getDefaults().getCallbackMode() & 2) != 0;
        boolean bl = this._full = full && broker.getDetachState() == 1;
        if (this._full) {
            this._detached = null;
            this._fullFM = new DetachFieldManager();
        } else {
            this._detached = new IdentityHashMap();
            this._fullFM = null;
        }
        Compatibility compatibility = broker.getConfiguration().getCompatibilityInstance();
        this._flushBeforeDetach = compatibility.getFlushBeforeDetach();
        this._reloadOnDetach = compatibility.getReloadOnDetach();
        this._cascadeWithDetach = compatibility.getCascadeWithDetach();
        this._copy = full ? false : compatibility.getCopyOnDetach();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object detach(Object toDetach) {
        List<CallbackException> exceps = null;
        try {
            Object object = this.detachInternal(toDetach);
            return object;
        }
        catch (CallbackException ce) {
            exceps = new ArrayList<CallbackException>(1);
            exceps.add(ce);
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            if (exceps == null || !this._failFast) {
                exceps = this.invokeAfterDetach(Collections.singleton(toDetach), exceps);
            }
            if (this._detached != null) {
                this._detached.clear();
            }
            this.throwExceptions(exceps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] detachAll(Collection instances) {
        ArrayList<Object> detached;
        List exceps;
        block13: {
            exceps = null;
            detached = null;
            if (this._copy) {
                detached = new ArrayList<Object>(instances.size());
            }
            boolean failFast = false;
            try {
                for (Object instance : instances) {
                    Object detach = this.detachInternal(instance);
                    if (!this._copy) continue;
                    detached.add(detach);
                }
                if (failFast) break block13;
            }
            catch (RuntimeException re) {
                try {
                    if (re instanceof CallbackException && this._failFast) {
                        failFast = true;
                    }
                    exceps = this.add(exceps, re);
                    if (!failFast) {
                        exceps = this.invokeAfterDetach(instances, exceps);
                    }
                    if (this._detached != null) {
                        this._detached.clear();
                    }
                }
                catch (Throwable throwable) {
                    if (!failFast) {
                        exceps = this.invokeAfterDetach(instances, exceps);
                    }
                    if (this._detached != null) {
                        this._detached.clear();
                    }
                    throw throwable;
                }
            }
            exceps = this.invokeAfterDetach(instances, exceps);
        }
        if (this._detached != null) {
            this._detached.clear();
        }
        this.throwExceptions(exceps);
        if (this._copy) {
            return detached.toArray();
        }
        return null;
    }

    private List invokeAfterDetach(Collection objs, List exceps) {
        Iterator itr;
        Iterator<Object> iterator = itr = this._full ? objs.iterator() : this._detached.entrySet().iterator();
        while (itr.hasNext()) {
            Object detached;
            Object orig;
            if (this._full) {
                detached = orig = itr.next();
            } else {
                Map.Entry entry = (Map.Entry)itr.next();
                orig = entry.getKey();
                detached = entry.getValue();
            }
            StateManagerImpl sm = this._broker.getStateManagerImpl(orig, true);
            try {
                if (sm == null) continue;
                this._broker.fireLifecycleEvent(detached, orig, sm.getMetaData(), 14);
            }
            catch (CallbackException ce) {
                exceps = this.add(exceps, ce);
                if (!this._failFast) continue;
                break;
            }
        }
        return exceps;
    }

    private List add(List exceps, RuntimeException re) {
        if (exceps == null) {
            exceps = new LinkedList<RuntimeException>();
        }
        exceps.add(re);
        return exceps;
    }

    private void throwExceptions(List exceps) {
        if (exceps == null) {
            return;
        }
        if (exceps.size() == 1) {
            throw (RuntimeException)exceps.get(0);
        }
        throw new UserException(_loc.get("nested-exceps")).setNestedThrowables(exceps.toArray(new Throwable[exceps.size()]));
    }

    private Object detachInternal(Object toDetach) {
        Object detached;
        if (toDetach == null) {
            return null;
        }
        if (this._detached != null && (detached = this._detached.get(toDetach)) != null) {
            return detached;
        }
        StateManagerImpl sm = this._broker.getStateManagerImpl(toDetach, true);
        if (this._call != null && (this._call.processArgument(7, toDetach, sm) & 4) == 0) {
            return toDetach;
        }
        if (sm == null) {
            return toDetach;
        }
        this._broker.fireLifecycleEvent(toDetach, null, sm.getMetaData(), 13);
        if (!this._flushed) {
            if (this._flushBeforeDetach) {
                DetachManager.flushDirty(sm);
            }
            this._flushed = true;
        }
        BitSet fields = new BitSet();
        DetachManager.preDetach(this._broker, sm, fields, this._full, this._reloadOnDetach);
        PersistenceCapable pc = sm.getPersistenceCapable();
        PersistenceCapable detachedPC = this._copy ? pc.pcNewInstance(null, true) : pc;
        if (this._detached != null) {
            this._detached.put(toDetach, detachedPC);
        }
        DetachedStateManager detSM = null;
        if (this._opts.getDetachedStateManager() && DetachManager.useDetachedStateManager(sm, this._opts) && (!sm.isNew() || sm.isDeleted() || sm.isFlushed())) {
            detSM = new DetachedStateManager(detachedPC, sm, fields, this._opts.getAccessUnloaded(), this._broker.getMultithreaded());
        }
        if (this._full) {
            this._fullFM.setStateManager(sm);
            if (this._copy || this._reloadOnDetach) {
                this._fullFM.detachVersion();
            }
            this._fullFM.reproxy(detSM);
            this._fullFM.setStateManager(null);
        } else {
            InstanceDetachFieldManager fm = new InstanceDetachFieldManager(detachedPC, detSM);
            fm.setStateManager(sm);
            fm.detachFields(fields);
        }
        if (!Boolean.FALSE.equals(sm.getMetaData().usesDetachedState())) {
            detachedPC.pcSetDetachedState(DetachManager.getDetachedState(sm, fields));
        }
        if (!this._copy) {
            sm.release(false, true);
        }
        if (detSM != null) {
            detachedPC.pcReplaceStateManager(detSM);
        }
        return detachedPC;
    }

    private static boolean useDetachedStateManager(StateManagerImpl sm, DetachOptions opts) {
        ClassMetaData meta = sm.getMetaData();
        return !Boolean.FALSE.equals(meta.usesDetachedState()) && "`syn".equals(meta.getDetachedState()) && opts.getDetachedStateManager();
    }

    private class InstanceDetachFieldManager
    extends DetachFieldManager {
        private final PersistenceCapable _to;
        private final DetachedStateManager _detSM;

        public InstanceDetachFieldManager(PersistenceCapable to, DetachedStateManager detSM) {
            this._to = to;
            this._detSM = detSM;
        }

        @Override
        protected PersistenceCapable getDetachedPersistenceCapable() {
            return this._to;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void detachFields(BitSet fgfields) {
            PersistenceCapable from = this.sm.getPersistenceCapable();
            FieldMetaData[] pks = this.sm.getMetaData().getPrimaryKeyFields();
            FieldMetaData[] fmds = this.sm.getMetaData().getFields();
            if (DetachManager.this._copy) {
                this._to.pcReplaceStateManager(this.sm);
            }
            try {
                for (FieldMetaData pk : pks) {
                    this.detachField(from, pk.getIndex(), true);
                }
                this.detachVersion();
                for (int i = 0; i < fmds.length; ++i) {
                    if (fmds[i].isPrimaryKey() || fmds[i].isVersion()) continue;
                    this.detachField(from, i, fgfields.get(i));
                }
            }
            finally {
                if (DetachManager.this._copy) {
                    this._to.pcReplaceStateManager(null);
                }
            }
        }

        private void detachField(PersistenceCapable from, int i, boolean fg) {
            if (fg) {
                this.sm.provideField(from, this, i);
            } else if (!DetachManager.this._copy) {
                this.clear();
                this.sm.replaceField(this._to, this, i);
            }
        }

        @Override
        public void storeBooleanField(int field, boolean curVal) {
            super.storeBooleanField(field, curVal);
            this.sm.replaceField(this._to, this, field);
        }

        @Override
        public void storeByteField(int field, byte curVal) {
            super.storeByteField(field, curVal);
            this.sm.replaceField(this._to, this, field);
        }

        @Override
        public void storeCharField(int field, char curVal) {
            super.storeCharField(field, curVal);
            this.sm.replaceField(this._to, this, field);
        }

        @Override
        public void storeDoubleField(int field, double curVal) {
            super.storeDoubleField(field, curVal);
            this.sm.replaceField(this._to, this, field);
        }

        @Override
        public void storeFloatField(int field, float curVal) {
            super.storeFloatField(field, curVal);
            this.sm.replaceField(this._to, this, field);
        }

        @Override
        public void storeIntField(int field, int curVal) {
            super.storeIntField(field, curVal);
            this.sm.replaceField(this._to, this, field);
        }

        @Override
        public void storeLongField(int field, long curVal) {
            super.storeLongField(field, curVal);
            this.sm.replaceField(this._to, this, field);
        }

        @Override
        public void storeShortField(int field, short curVal) {
            super.storeShortField(field, curVal);
            this.sm.replaceField(this._to, this, field);
        }

        @Override
        public void storeStringField(int field, String curVal) {
            super.storeStringField(field, curVal);
            this.sm.replaceField(this._to, this, field);
        }

        @Override
        public void storeObjectField(int field, Object curVal) {
            super.storeObjectField(field, this.detachField(curVal, field));
            this.sm.replaceField(this._to, this, field);
        }

        private Object reproxy(Object obj, int field) {
            if (obj != null && this._detSM != null && obj instanceof Proxy) {
                ((Proxy)obj).setOwner(this._detSM, field);
            }
            return obj;
        }

        private Object detachField(Object curVal, int field) {
            if (curVal == null) {
                return null;
            }
            FieldMetaData fmd = this.sm.getMetaData().getField(field);
            boolean cascade = false;
            if (DetachManager.this._cascadeWithDetach || fmd.getCascadeDetach() == 1 || fmd.getKey().getCascadeDetach() == 1 || fmd.getElement().getCascadeDetach() == 1) {
                cascade = true;
            }
            Object newVal = null;
            switch (fmd.getDeclaredTypeCode()) {
                case 11: {
                    newVal = DetachManager.this._copy ? DetachManager.this._proxy.copyArray(curVal) : curVal;
                    if (cascade) {
                        this.detachArray(newVal, fmd);
                    }
                    return newVal;
                }
                case 12: {
                    if (DetachManager.this._copy) {
                        if (this._detSM != null) {
                            newVal = DetachManager.this._proxy.newCollectionProxy(fmd.getProxyType(), fmd.getElement().getDeclaredType(), fmd.getInitializer() instanceof Comparator ? (Comparator)fmd.getInitializer() : null, this.sm.getBroker().getConfiguration().getCompatibilityInstance().getAutoOff());
                            ((Collection)newVal).addAll((Collection)curVal);
                        } else {
                            newVal = DetachManager.this._proxy.copyCollection((Collection)curVal);
                        }
                    } else {
                        newVal = curVal;
                    }
                    if (cascade) {
                        this.detachCollection((Collection)newVal, (Collection)curVal, fmd);
                    }
                    return this.reproxy(newVal, field);
                }
                case 13: {
                    if (DetachManager.this._copy) {
                        if (this._detSM != null) {
                            newVal = DetachManager.this._proxy.newMapProxy(fmd.getProxyType(), fmd.getKey().getDeclaredType(), fmd.getElement().getDeclaredType(), fmd.getInitializer() instanceof Comparator ? (Comparator)fmd.getInitializer() : null, this.sm.getBroker().getConfiguration().getCompatibilityInstance().getAutoOff());
                            ((Map)newVal).putAll((Map)curVal);
                        } else {
                            newVal = DetachManager.this._proxy.copyMap((Map)curVal);
                        }
                    } else {
                        newVal = curVal;
                    }
                    if (cascade) {
                        this.detachMap((Map)newVal, (Map)curVal, fmd);
                    }
                    return this.reproxy(newVal, field);
                }
                case 28: {
                    newVal = DetachManager.this._copy ? DetachManager.this._proxy.copyCalendar((Calendar)curVal) : curVal;
                    return this.reproxy(newVal, field);
                }
                case 14: {
                    newVal = DetachManager.this._copy ? DetachManager.this._proxy.copyDate((Date)curVal) : curVal;
                    return this.reproxy(newVal, field);
                }
                case 8: {
                    if (DetachManager.this._copy) {
                        newVal = DetachManager.this._proxy.copyCustom(curVal);
                    }
                    return this.reproxy(newVal == null ? curVal : newVal, field);
                }
                case 15: 
                case 27: {
                    if (cascade) {
                        return DetachManager.this.detachInternal(curVal);
                    }
                    return curVal;
                }
            }
            return curVal;
        }

        private void detachArray(Object array, FieldMetaData fmd) {
            if (!fmd.getElement().isDeclaredTypePC()) {
                return;
            }
            int len = Array.getLength(array);
            for (int i = 0; i < len; ++i) {
                Array.set(array, i, DetachManager.this.detachInternal(Array.get(array, i)));
            }
        }

        private void detachCollection(Collection coll, Collection orig, FieldMetaData fmd) {
            if (DetachManager.this._copy && coll == null) {
                throw new UserException(_loc.get("not-copyable", fmd));
            }
            if (!fmd.getElement().isDeclaredTypePC()) {
                return;
            }
            if (DetachManager.this._copy) {
                coll.clear();
            }
            for (Object o : orig) {
                Object detached = DetachManager.this.detachInternal(o);
                if (!DetachManager.this._copy) continue;
                coll.add(detached);
            }
        }

        private void detachMap(Map map, Map orig, FieldMetaData fmd) {
            if (DetachManager.this._copy && map == null) {
                throw new UserException(_loc.get("not-copyable", fmd));
            }
            boolean keyPC = fmd.getKey().isDeclaredTypePC();
            boolean valPC = fmd.getElement().isDeclaredTypePC();
            if (!keyPC && !valPC) {
                return;
            }
            if (!DetachManager.this._copy || keyPC) {
                if (DetachManager.this._copy) {
                    map.clear();
                }
                Iterator iterator = orig.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = iterator.next();
                    Object key = entry.getKey();
                    if (keyPC) {
                        key = DetachManager.this.detachInternal(key);
                    }
                    Object val = entry.getValue();
                    if (valPC) {
                        val = DetachManager.this.detachInternal(val);
                    }
                    if (!DetachManager.this._copy) continue;
                    map.put(key, val);
                }
            } else {
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = iterator.next();
                    entry.setValue(DetachManager.this.detachInternal(entry.getValue()));
                }
            }
        }
    }

    private static class DetachFieldManager
    extends TransferFieldManager {
        protected StateManagerImpl sm;

        private DetachFieldManager() {
        }

        public void setStateManager(StateManagerImpl sm) {
            this.sm = sm;
        }

        public void detachVersion() {
            FieldMetaData fmd = this.sm.getMetaData().getVersionField();
            if (fmd == null) {
                return;
            }
            Object val = JavaTypes.convert(this.sm.getVersion(), fmd.getTypeCode());
            val = fmd.getFieldValue(val, this.sm.getBroker());
            switch (fmd.getDeclaredTypeCode()) {
                case 1: 
                case 5: 
                case 6: 
                case 7: {
                    this.longval = val == null ? 0L : ((Number)val).longValue();
                    break;
                }
                case 3: 
                case 4: {
                    this.dblval = val == null ? 0.0 : ((Number)val).doubleValue();
                    break;
                }
                default: {
                    this.objval = val;
                }
            }
            this.sm.replaceField(this.getDetachedPersistenceCapable(), this, fmd.getIndex());
        }

        public void reproxy(DetachedStateManager dsm) {
            block4: for (FieldMetaData fmd : this.sm.getMetaData().getProxyFields()) {
                switch (fmd.getDeclaredTypeCode()) {
                    case 12: 
                    case 13: {
                        if (fmd.isLRS()) {
                            this.objval = null;
                            this.sm.replaceField(this.getDetachedPersistenceCapable(), this, fmd.getIndex());
                            continue block4;
                        }
                    }
                    case 8: 
                    case 14: 
                    case 28: {
                        this.sm.provideField(this.getDetachedPersistenceCapable(), this, fmd.getIndex());
                        if (!(this.objval instanceof Proxy)) continue block4;
                        Proxy proxy2 = (Proxy)this.objval;
                        if (proxy2.getChangeTracker() != null) {
                            proxy2.getChangeTracker().stopTracking();
                        }
                        proxy2.setOwner(dsm, dsm == null ? -1 : fmd.getIndex());
                    }
                }
            }
            this.clear();
        }

        protected PersistenceCapable getDetachedPersistenceCapable() {
            return this.sm.getPersistenceCapable();
        }
    }
}

