/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core.quota;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaUsageValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotaCountUsage
implements QuotaUsageValue<QuotaCountUsage, QuotaCountLimit> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuotaCountUsage.class);
    private final long value;

    public static QuotaCountUsage count(long value) {
        return new QuotaCountUsage(value);
    }

    private QuotaCountUsage(long value) {
        this.value = value;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public QuotaCountUsage add(long additionalValue) {
        return new QuotaCountUsage(this.value + additionalValue);
    }

    @Override
    public QuotaCountUsage add(QuotaCountUsage additionalValue) {
        return new QuotaCountUsage(this.value + additionalValue.asLong());
    }

    public boolean isValid() {
        return this.value >= 0L;
    }

    public Sanitized sanitize() {
        if (!this.isValid()) {
            LOGGER.warn("Invalid quota count usage : {}", (Object)this.value);
        }
        return Sanitized.of(Math.max(this.value, 0L));
    }

    @Override
    public boolean exceedLimit(QuotaCountLimit limit) {
        if (limit.isLimited()) {
            return this.value > limit.asLong();
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.value).toString();
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaCountUsage) {
            QuotaCountUsage that = (QuotaCountUsage)o;
            return Objects.equal((Object)this.value, (Object)that.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value});
    }

    public static class Sanitized
    extends QuotaCountUsage {
        private static Sanitized of(long value) {
            Preconditions.checkArgument((value >= 0L ? 1 : 0) != 0, (Object)"Sanitized quota shall be positive");
            return new Sanitized((Long)value);
        }

        private Sanitized(Long value) {
            super(value);
        }
    }
}

