/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import org.apache.james.backends.cassandra.components.CassandraDataDefinition;
import org.apache.james.rrt.api.AliasReverseResolver;
import org.apache.james.rrt.api.CanSendFrom;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.cassandra.CassandraMappingsSourcesDAO;
import org.apache.james.rrt.cassandra.CassandraRRTDataDefinition;
import org.apache.james.rrt.cassandra.CassandraRecipientRewriteTable;
import org.apache.james.rrt.cassandra.CassandraRecipientRewriteTableDAO;
import org.apache.james.rrt.lib.AliasReverseResolverImpl;
import org.apache.james.rrt.lib.CanSendFromImpl;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;

public class CassandraRecipientRewriteTableModule
extends AbstractModule {
    public void configure() {
        this.bind(CassandraRecipientRewriteTable.class).in(Scopes.SINGLETON);
        this.bind(CassandraRecipientRewriteTableDAO.class).in(Scopes.SINGLETON);
        this.bind(CassandraMappingsSourcesDAO.class).in(Scopes.SINGLETON);
        this.bind(RecipientRewriteTable.class).to(CassandraRecipientRewriteTable.class);
        this.bind(AliasReverseResolverImpl.class).in(Scopes.SINGLETON);
        this.bind(AliasReverseResolver.class).to(AliasReverseResolverImpl.class);
        this.bind(CanSendFromImpl.class).in(Scopes.SINGLETON);
        this.bind(CanSendFrom.class).to(CanSendFromImpl.class);
        Multibinder cassandraDataDefinitions = Multibinder.newSetBinder((Binder)this.binder(), CassandraDataDefinition.class);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraRRTDataDefinition.MODULE);
    }

    @ProvidesIntoSet
    InitializationOperation configureRecipientRewriteTable(ConfigurationProvider configurationProvider, CassandraRecipientRewriteTable recipientRewriteTable) {
        return InitilizationOperationBuilder.forClass(CassandraRecipientRewriteTable.class).init(() -> recipientRewriteTable.configure(configurationProvider.getConfiguration("recipientrewritetable")));
    }
}

