/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.data.jmap;

import java.util.Optional;
import org.apache.james.webadmin.data.jmap.RunningOptions;
import spark.Request;

public class RunningOptionsParser {
    public static RunningOptions parse(Request request) {
        return RunningOptionsParser.intQueryParameter(request, "messagesPerSecond").map(RunningOptions::withMessageRatePerSecond).orElse(RunningOptions.DEFAULT);
    }

    public static Optional<Integer> intQueryParameter(Request request, String queryParameter) {
        try {
            return Optional.ofNullable(request.queryParams(queryParameter)).map(Integer::parseInt);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Illegal value supplied for query parameter '%s', expecting a strictly positive optional integer", queryParameter), e);
        }
    }
}

