/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.probe.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import org.apache.james.cli.probe.impl.JmxConnection;
import org.apache.james.cli.probe.impl.JmxProbe;
import org.apache.james.domainlist.api.DomainListManagementMBean;
import org.apache.james.rrt.api.RecipientRewriteTableManagementMBean;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.user.api.UsersRepositoryManagementMBean;
import org.apache.james.util.MDCBuilder;

public class JmxDataProbe
implements JmxProbe {
    private static final String DOMAINLIST_OBJECT_NAME = "org.apache.james:type=component,name=domainlist";
    private static final String VIRTUALUSERTABLE_OBJECT_NAME = "org.apache.james:type=component,name=recipientrewritetable";
    private static final String USERSREPOSITORY_OBJECT_NAME = "org.apache.james:type=component,name=usersrepository";
    private static final String JMX = "JMX";
    private static final String PARAMETER = "parameter";
    private DomainListManagementMBean domainListProxy;
    private RecipientRewriteTableManagementMBean virtualUserTableProxy;
    private UsersRepositoryManagementMBean usersRepositoryProxy;

    @Override
    public JmxDataProbe connect(JmxConnection jmxc) throws IOException {
        try {
            this.domainListProxy = jmxc.retrieveBean(DomainListManagementMBean.class, DOMAINLIST_OBJECT_NAME);
            this.virtualUserTableProxy = jmxc.retrieveBean(RecipientRewriteTableManagementMBean.class, VIRTUALUSERTABLE_OBJECT_NAME);
            this.usersRepositoryProxy = jmxc.retrieveBean(UsersRepositoryManagementMBean.class, USERSREPOSITORY_OBJECT_NAME);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        return this;
    }

    public void addUser(String userName, String password) throws Exception {
        try (Closeable closeable = this.buildMdc("addUser", userName);){
            this.usersRepositoryProxy.addUser(userName, password);
        }
    }

    public void removeUser(String username) throws Exception {
        try (Closeable closeable = this.buildMdc("removeUser", username);){
            this.usersRepositoryProxy.deleteUser(username);
        }
    }

    public String[] listUsers() throws Exception {
        try (Closeable closeable = this.buildMdc("listUsers");){
            String[] stringArray = this.usersRepositoryProxy.listAllUsers();
            return stringArray;
        }
    }

    public void setPassword(String userName, String password) throws Exception {
        try (Closeable closeable = this.buildMdc("setPassword", userName);){
            this.usersRepositoryProxy.setPassword(userName, password);
        }
    }

    public boolean containsDomain(String domain) throws Exception {
        try (Closeable closeable = this.buildMdc("containsDomain", domain);){
            boolean bl = this.domainListProxy.containsDomain(domain);
            return bl;
        }
    }

    public void addDomain(String domain) throws Exception {
        try (Closeable closeable = this.buildMdc("addDomain", domain);){
            this.domainListProxy.addDomain(domain);
        }
    }

    public void removeDomain(String domain) throws Exception {
        try (Closeable closeable = this.buildMdc("removeDomain", domain);){
            this.domainListProxy.removeDomain(domain);
        }
    }

    public List<String> listDomains() throws Exception {
        try (Closeable closeable = this.buildMdc("listDomains");){
            List list = this.domainListProxy.getDomains();
            return list;
        }
    }

    public void addDomainMapping(String domain, String targetDomain) throws Exception {
        try (Closeable closeable = this.buildMdc("addDomainMapping");){
            this.virtualUserTableProxy.addDomainMapping(domain, targetDomain);
        }
    }

    public void removeDomainMapping(String domain, String targetDomain) throws Exception {
        try (Closeable closeable = this.buildMdc("removeDomainMapping");){
            this.virtualUserTableProxy.removeDomainMapping(domain, targetDomain);
        }
    }

    public Mappings listDomainMappings(String domain) throws Exception {
        try (Closeable closeable = this.buildMdc("listDomainMappings");){
            Mappings mappings = this.virtualUserTableProxy.getDomainMappings(domain);
            return mappings;
        }
    }

    public Map<String, Mappings> listMappings() throws Exception {
        try (Closeable closeable = this.buildMdc("listMappings");){
            Map map = this.virtualUserTableProxy.getAllMappings();
            return map;
        }
    }

    public void addAddressMapping(String fromUser, String fromDomain, String toAddress) throws Exception {
        try (Closeable closeable = this.buildMdc("addAddressMapping");){
            this.virtualUserTableProxy.addAddressMapping(fromUser, fromDomain, toAddress);
        }
    }

    public void removeAddressMapping(String fromUser, String fromDomain, String toAddress) throws Exception {
        try (Closeable closeable = this.buildMdc("removeAddressMapping");){
            this.virtualUserTableProxy.removeAddressMapping(fromUser, fromDomain, toAddress);
        }
    }

    public Mappings listUserDomainMappings(String user, String domain) throws Exception {
        try (Closeable closeable = this.buildMdc("listUserDomainMappings");){
            Mappings mappings = this.virtualUserTableProxy.getUserDomainMappings(user, domain);
            return mappings;
        }
    }

    public void addRegexMapping(String user, String domain, String regex) throws Exception {
        try (Closeable closeable = this.buildMdc("addRegexMapping");){
            this.virtualUserTableProxy.addRegexMapping(user, domain, regex);
        }
    }

    public void removeRegexMapping(String user, String domain, String regex) throws Exception {
        try (Closeable closeable = this.buildMdc("removeRegexMapping");){
            this.virtualUserTableProxy.removeRegexMapping(user, domain, regex);
        }
    }

    private Closeable buildMdc(String action) {
        return MDCBuilder.create().addToContext("protocol", JMX).addToContext("action", action).build();
    }

    private Closeable buildMdc(String action, String parameter) {
        return MDCBuilder.create().addToContext("protocol", JMX).addToContext("action", action).addToContext(PARAMETER, parameter).build();
    }
}

