/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search.opensearch;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.james.quota.search.QuotaClause;
import org.apache.james.quota.search.QuotaQuery;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.MatchAllQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.RangeQuery;
import org.opensearch.client.opensearch._types.query_dsl.TermQuery;

class QuotaQueryConverter {
    private final Map<Class<? extends QuotaClause>, Function<QuotaClause, Query>> clauseConverter;

    QuotaQueryConverter() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(QuotaClause.HasDomain.class, this::convertHasDomain);
        builder.put(QuotaClause.And.class, this::disableNestedAnd);
        builder.put(QuotaClause.MoreThan.class, this::convertMoreThan);
        builder.put(QuotaClause.LessThan.class, this::convertLessThan);
        this.clauseConverter = builder.build();
    }

    Query from(QuotaQuery query) {
        List clauses = query.getClause().getClauses();
        if (clauses.isEmpty()) {
            return new MatchAllQuery.Builder().build().toQuery();
        }
        if (clauses.size() == 1) {
            return this.singleClauseAsESQuery((QuotaClause)clauses.get(0));
        }
        return this.clausesAsAndESQuery(clauses);
    }

    private Query clausesAsAndESQuery(List<QuotaClause> clauses) {
        BoolQuery.Builder boolQueryBuilder = new BoolQuery.Builder();
        clauses.stream().map(this::singleClauseAsESQuery).forEach(x$0 -> boolQueryBuilder.must(x$0, new Query[0]));
        return boolQueryBuilder.build().toQuery();
    }

    private Query disableNestedAnd(QuotaClause clause) {
        throw new IllegalArgumentException("Nested \"And\" clauses are not supported");
    }

    private Query convertHasDomain(QuotaClause clause) {
        QuotaClause.HasDomain hasDomain = (QuotaClause.HasDomain)clause;
        return new TermQuery.Builder().field("domain").value((FieldValue)new FieldValue.Builder().stringValue(hasDomain.getDomain().asString()).build()).build().toQuery();
    }

    private Query convertMoreThan(QuotaClause clause) {
        QuotaClause.MoreThan moreThan = (QuotaClause.MoreThan)clause;
        return new RangeQuery.Builder().field("quotaRatio").gte(JsonData.of((Object)moreThan.getQuotaBoundary().getRatio())).build().toQuery();
    }

    private Query convertLessThan(QuotaClause clause) {
        QuotaClause.LessThan lessThan = (QuotaClause.LessThan)clause;
        return new RangeQuery.Builder().field("quotaRatio").lte(JsonData.of((Object)lessThan.getQuotaBoundary().getRatio())).build().toQuery();
    }

    private Query singleClauseAsESQuery(QuotaClause clause) {
        return this.clauseConverter.get(clause.getClass()).apply(clause);
    }
}

