/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.derby.iapi.jdbc.JDBCBoot;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.AutoloadedDriver;

public class EmbeddedDriver
implements Driver {
    public EmbeddedDriver() {
        EmbeddedDriver.boot();
    }

    @Override
    public boolean acceptsURL(String string) throws SQLException {
        return this.getDriverModule().acceptsURL(string);
    }

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        return this.getDriverModule().connect(string, properties);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return this.getDriverModule().getPropertyInfo(string, properties);
    }

    @Override
    public int getMajorVersion() {
        try {
            return this.getDriverModule().getMajorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    @Override
    public int getMinorVersion() {
        try {
            return this.getDriverModule().getMinorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    @Override
    public boolean jdbcCompliant() {
        try {
            return this.getDriverModule().jdbcCompliant();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    private Driver getDriverModule() throws SQLException {
        return AutoloadedDriver.getDriverModule();
    }

    static void boot() {
        block3: {
            PrintWriter printWriter = DriverManager.getLogWriter();
            if (printWriter == null) {
                printWriter = new PrintWriter(System.err, true);
            }
            try {
                new JDBCBoot().boot("jdbc:derby:", printWriter);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(printWriter);
                if (!(throwable instanceof RuntimeException)) break block3;
                throw (RuntimeException)throwable;
            }
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw (SQLFeatureNotSupportedException)Util.notImplemented("getParentLogger()");
    }

    static {
        EmbeddedDriver.boot();
    }
}

