/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.impl.MvndDaemonLogger;
import org.slf4j.impl.MvndSimpleLogger;
import org.slf4j.impl.SimpleLoggerConfiguration;

public class MvndLoggerFactory
implements ILoggerFactory {
    private final ConcurrentMap<String, Logger> loggerMap = new ConcurrentHashMap<String, Logger>();

    public MvndLoggerFactory() {
        MvndSimpleLogger.lazyInit();
    }

    public Logger getLogger(String name) {
        return this.loggerMap.computeIfAbsent(name, this::getNewLoggingInstance);
    }

    private Logger getNewLoggingInstance(String name) {
        if (name.startsWith("org.mvndaemon.mvnd.daemon")) {
            return new MvndDaemonLogger(name);
        }
        return new MvndSimpleLogger(name);
    }

    public void reconfigure() {
        SimpleLoggerConfiguration config = MvndSimpleLogger.CONFIG_PARAMS;
        config.init();
        this.loggerMap.values().forEach(l -> {
            if (l instanceof MvndSimpleLogger) {
                ((MvndSimpleLogger)((Object)l)).configure(config.defaultLogLevel);
            }
        });
    }
}

