/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.daemon;

import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.management.Attribute;
import javax.management.ObjectName;
import org.mvndaemon.mvnd.common.DaemonCompatibilitySpec;
import org.mvndaemon.mvnd.common.DaemonExpirationStatus;
import org.mvndaemon.mvnd.common.DaemonInfo;
import org.mvndaemon.mvnd.common.DaemonState;
import org.mvndaemon.mvnd.common.Environment;
import org.mvndaemon.mvnd.common.Os;
import org.mvndaemon.mvnd.common.TimeUtils;
import org.mvndaemon.mvnd.daemon.Server;
import org.mvndaemon.mvnd.nativ.CLibrary;

public class DaemonExpiration {
    public static DaemonExpirationStrategy master() {
        return DaemonExpiration.any(DaemonExpiration.any(DaemonExpiration.gcTrashing(), DaemonExpiration.lowHeapSpace(), DaemonExpiration.lowNonHeap()), DaemonExpiration.all(DaemonExpiration.compatible(), DaemonExpiration.duplicateGracePeriod(), DaemonExpiration.notMostRecentlyUsed()), DaemonExpiration.idleTimeout(Environment.MVND_IDLE_TIMEOUT.asDuration()), DaemonExpiration.all(DaemonExpiration.duplicateGracePeriod(), DaemonExpiration.notMostRecentlyUsed(), DaemonExpiration.lowMemory(0.05)), DaemonExpiration.registryUnavailable());
    }

    static DaemonExpirationStrategy gcTrashing() {
        return daemon -> daemon.getMemoryStatus().isTrashing() ? new DaemonExpirationResult(DaemonExpirationStatus.IMMEDIATE_EXPIRE, "JVM garbage collector thrashing") : DaemonExpirationResult.NOT_TRIGGERED;
    }

    static DaemonExpirationStrategy lowHeapSpace() {
        return daemon -> daemon.getMemoryStatus().isHeapSpaceExhausted() ? new DaemonExpirationResult(DaemonExpirationStatus.GRACEFUL_EXPIRE, "after running out of JVM memory") : DaemonExpirationResult.NOT_TRIGGERED;
    }

    static DaemonExpirationStrategy lowNonHeap() {
        return daemon -> daemon.getMemoryStatus().isNonHeapSpaceExhausted() ? new DaemonExpirationResult(DaemonExpirationStatus.GRACEFUL_EXPIRE, "after running out of JVM memory") : DaemonExpirationResult.NOT_TRIGGERED;
    }

    static DaemonExpirationStrategy lowMemory(double minFreeMemoryPercentage) {
        if (Os.current() == Os.MAC) {
            return new OsxMemoryExpirationStrategy(minFreeMemoryPercentage);
        }
        if (Os.current() == Os.LINUX) {
            return new MemInfoMemoryExpirationStrategy(minFreeMemoryPercentage);
        }
        return new MBeanMemoryExpirationStrategy(minFreeMemoryPercentage);
    }

    static DaemonExpirationStrategy duplicateGracePeriod() {
        return DaemonExpiration.idleTimeout(Environment.MVND_DUPLICATE_DAEMON_GRACE_PERIOD.asDuration());
    }

    static DaemonExpirationStrategy idleTimeout(Duration timeout) {
        return daemon -> {
            Duration idl = Duration.between(Instant.ofEpochMilli(daemon.getLastIdle()), Instant.now());
            if (daemon.getState() == DaemonState.Idle && idl.compareTo(timeout) > 0) {
                return new DaemonExpirationResult(DaemonExpirationStatus.QUIET_EXPIRE, "after being idle for " + TimeUtils.printDuration((Duration)idl));
            }
            return DaemonExpirationResult.NOT_TRIGGERED;
        };
    }

    static DaemonExpirationStrategy notMostRecentlyUsed() {
        return daemon -> daemon.getRegistry().getIdle().stream().max(Comparator.comparingLong(DaemonInfo::getLastBusy)).map(d -> Objects.equals(d.getId(), daemon.getDaemonId())).orElse(false) != false ? new DaemonExpirationResult(DaemonExpirationStatus.GRACEFUL_EXPIRE, "not recently used") : DaemonExpirationResult.NOT_TRIGGERED;
    }

    static DaemonExpirationStrategy registryUnavailable() {
        return daemon -> {
            try {
                if (!Files.isReadable(daemon.getRegistry().getRegistryFile())) {
                    return new DaemonExpirationResult(DaemonExpirationStatus.GRACEFUL_EXPIRE, "after the daemon registry became unreadable");
                }
                if (daemon.getRegistry().get(daemon.getDaemonId()) == null) {
                    return new DaemonExpirationResult(DaemonExpirationStatus.GRACEFUL_EXPIRE, "after the daemon was no longer found in the daemon registry");
                }
                return DaemonExpirationResult.NOT_TRIGGERED;
            }
            catch (SecurityException e) {
                return new DaemonExpirationResult(DaemonExpirationStatus.GRACEFUL_EXPIRE, "after the daemon registry became inaccessible");
            }
        };
    }

    static DaemonExpirationStrategy compatible() {
        return daemon -> {
            DaemonCompatibilitySpec constraint = new DaemonCompatibilitySpec(Paths.get(daemon.getInfo().getJavaHome(), new String[0]), daemon.getInfo().getOptions());
            long compatible = daemon.getRegistry().getAll().stream().map(arg_0 -> ((DaemonCompatibilitySpec)constraint).isSatisfiedBy(arg_0)).filter(DaemonCompatibilitySpec.Result::isCompatible).count();
            if (compatible > 1L) {
                return new DaemonExpirationResult(DaemonExpirationStatus.GRACEFUL_EXPIRE, "other compatible daemons were started");
            }
            return DaemonExpirationResult.NOT_TRIGGERED;
        };
    }

    static DaemonExpirationStrategy all(DaemonExpirationStrategy ... strategies) {
        return daemon -> {
            DaemonExpirationResult expirationResult = DaemonExpirationResult.NOT_TRIGGERED;
            DaemonExpirationStatus expirationStatus = DaemonExpirationStatus.DO_NOT_EXPIRE;
            ArrayList<String> reasons = new ArrayList<String>();
            for (DaemonExpirationStrategy expirationStrategy : strategies) {
                expirationResult = expirationStrategy.checkExpiration(daemon);
                if (expirationResult.getStatus() == DaemonExpirationStatus.DO_NOT_EXPIRE) {
                    return DaemonExpirationResult.NOT_TRIGGERED;
                }
                reasons.add(expirationResult.getReason());
                expirationStatus = DaemonExpiration.highestPriorityOf(expirationResult.getStatus(), expirationStatus);
            }
            if (expirationResult.getStatus() == DaemonExpirationStatus.DO_NOT_EXPIRE) {
                return DaemonExpirationResult.NOT_TRIGGERED;
            }
            return new DaemonExpirationResult(expirationStatus, DaemonExpiration.reason(reasons));
        };
    }

    static DaemonExpirationStrategy any(DaemonExpirationStrategy ... strategies) {
        return daemon -> {
            DaemonExpirationStatus expirationStatus = DaemonExpirationStatus.DO_NOT_EXPIRE;
            ArrayList<String> reasons = new ArrayList<String>();
            for (DaemonExpirationStrategy expirationStrategy : strategies) {
                DaemonExpirationResult expirationResult = expirationStrategy.checkExpiration(daemon);
                if (expirationResult.getStatus() == DaemonExpirationStatus.DO_NOT_EXPIRE) continue;
                reasons.add(expirationResult.getReason());
                expirationStatus = DaemonExpiration.highestPriorityOf(expirationResult.getStatus(), expirationStatus);
            }
            if (expirationStatus == DaemonExpirationStatus.DO_NOT_EXPIRE) {
                return DaemonExpirationResult.NOT_TRIGGERED;
            }
            return new DaemonExpirationResult(expirationStatus, DaemonExpiration.reason(reasons));
        };
    }

    private static String reason(List<String> reasons) {
        return reasons.stream().filter(Objects::nonNull).collect(Collectors.joining(" and "));
    }

    private static DaemonExpirationStatus highestPriorityOf(DaemonExpirationStatus left, DaemonExpirationStatus right) {
        if (left.ordinal() > right.ordinal()) {
            return left;
        }
        return right;
    }

    public static interface DaemonExpirationStrategy {
        public DaemonExpirationResult checkExpiration(Server var1);
    }

    private static class OsxMemoryExpirationStrategy
    extends MemoryExpirationStrategy {
        public OsxMemoryExpirationStrategy(double minFreeMemoryPercentage) {
            super(minFreeMemoryPercentage);
        }

        @Override
        protected long[] getTotalAndFreeMemory() throws Exception {
            long[] mem = new long[2];
            CLibrary.getOsxMemoryInfo((long[])mem);
            return mem;
        }
    }

    private static class MemInfoMemoryExpirationStrategy
    extends MemoryExpirationStrategy {
        public MemInfoMemoryExpirationStrategy(double minFreeMemoryPercentage) {
            super(minFreeMemoryPercentage);
        }

        @Override
        protected long[] getTotalAndFreeMemory() throws Exception {
            Matcher m = Pattern.compile("^(\\S+):\\s+(\\d+) kB$").matcher("");
            long total = -1L;
            long available = -1L;
            long free = -1L;
            long buffers = -1L;
            long cached = -1L;
            long reclaimable = -1L;
            long mapped = -1L;
            for (String line : Files.readAllLines(Paths.get("/proc/meminfo", new String[0]))) {
                if (!m.reset(line).matches()) continue;
                String key = m.group(1);
                long val = Long.parseLong(m.group(2)) * 1024L;
                switch (key) {
                    case "MemTotal": {
                        total = val;
                        break;
                    }
                    case "MemAvailable": {
                        available = val;
                        break;
                    }
                    case "MemFree": {
                        free = val;
                        break;
                    }
                    case "Buffers": {
                        buffers = val;
                        break;
                    }
                    case "Cached": {
                        cached = val;
                        break;
                    }
                    case "SReclaimable": {
                        reclaimable = val;
                        break;
                    }
                    case "Mapped": {
                        mapped = val;
                    }
                }
            }
            if (available < 0L && free != -1L && buffers != -1L && cached != -1L && reclaimable != -1L && mapped != -1L) {
                available = free + buffers + cached + reclaimable - mapped;
            }
            return new long[]{total, available};
        }
    }

    private static class MBeanMemoryExpirationStrategy
    extends MemoryExpirationStrategy {
        final boolean isIbmJvm;

        public MBeanMemoryExpirationStrategy(double minFreeMemoryPercentage) {
            super(minFreeMemoryPercentage);
            String vendor = System.getProperty("java.vm.vendor");
            this.isIbmJvm = vendor.toLowerCase(Locale.ROOT).startsWith("ibm corporation");
        }

        @Override
        protected long[] getTotalAndFreeMemory() throws Exception {
            ObjectName objectName = new ObjectName("java.lang:type=OperatingSystem");
            List<Attribute> list = ManagementFactory.getPlatformMBeanServer().getAttributes(objectName, new String[]{this.isIbmJvm ? "TotalPhysicalMemory" : "TotalPhysicalMemorySize", "FreePhysicalMemorySize"}).asList();
            long total = ((Number)list.get(0).getValue()).longValue();
            long free = ((Number)list.get(1).getValue()).longValue();
            return new long[]{total, free};
        }
    }

    public static class DaemonExpirationResult {
        public static final DaemonExpirationResult NOT_TRIGGERED = new DaemonExpirationResult(DaemonExpirationStatus.DO_NOT_EXPIRE, null);
        private final DaemonExpirationStatus status;
        private final String reason;

        public DaemonExpirationResult(DaemonExpirationStatus status, String reason) {
            this.status = status;
            this.reason = reason;
        }

        public DaemonExpirationStatus getStatus() {
            return this.status;
        }

        public String getReason() {
            return this.reason;
        }
    }

    private static abstract class MemoryExpirationStrategy
    implements DaemonExpirationStrategy {
        static final long MIN_THRESHOLD_BYTES = 0x18000000L;
        static final long MAX_THRESHOLD_BYTES = 0x40000000L;
        final double minFreeMemoryPercentage;

        public MemoryExpirationStrategy(double minFreeMemoryPercentage) {
            this.minFreeMemoryPercentage = minFreeMemoryPercentage;
        }

        @Override
        public DaemonExpirationResult checkExpiration(Server daemon) {
            try {
                double norm;
                long free;
                long total;
                long[] mem = this.getTotalAndFreeMemory();
                if (mem != null && mem.length == 2 && (total = mem[0]) > (free = mem[1]) && free > 0L && (double)free < (norm = Math.min(Math.max((double)total * this.minFreeMemoryPercentage, 4.02653184E8), 1.073741824E9))) {
                    return new DaemonExpirationResult(DaemonExpirationStatus.GRACEFUL_EXPIRE, "to reclaim system memory");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return DaemonExpirationResult.NOT_TRIGGERED;
        }

        protected abstract long[] getTotalAndFreeMemory() throws Exception;
    }
}

