/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.serialization.jackson;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import org.apache.nifi.registry.serialization.SerializationException;
import org.apache.nifi.registry.serialization.VersionedSerializer;
import org.apache.nifi.registry.serialization.jackson.ObjectMapperProvider;
import org.apache.nifi.registry.serialization.jackson.SerializationContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JacksonSerializer<T>
implements VersionedSerializer<T> {
    private static final Logger logger = LoggerFactory.getLogger(JacksonSerializer.class);
    private static final String JSON_HEADER = "\"header\"";
    private static final String DATA_MODEL_VERSION = "dataModelVersion";
    private final ObjectMapper objectMapper = ObjectMapperProvider.getMapper();

    @Override
    public void serialize(int dataModelVersion, T t, OutputStream out) throws SerializationException {
        if (t == null) {
            throw new IllegalArgumentException("The object to serialize cannot be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("OutputStream cannot be null");
        }
        SerializationContainer<T> container = new SerializationContainer<T>();
        container.setHeader(Collections.singletonMap(DATA_MODEL_VERSION, String.valueOf(dataModelVersion)));
        container.setContent(t);
        try {
            this.objectMapper.writerWithDefaultPrettyPrinter().writeValue(out, container);
        }
        catch (IOException e) {
            throw new SerializationException("Unable to serialize object", e);
        }
    }

    @Override
    public T deserialize(InputStream input) throws SerializationException {
        TypeReference<SerializationContainer<T>> typeRef = this.getDeserializeTypeRef();
        try {
            SerializationContainer container = (SerializationContainer)this.objectMapper.readValue(input, typeRef);
            return container.getContent();
        }
        catch (IOException e) {
            throw new SerializationException("Unable to deserialize object", e);
        }
    }

    abstract TypeReference<SerializationContainer<T>> getDeserializeTypeRef() throws SerializationException;

    @Override
    public int readDataModelVersion(InputStream input) throws SerializationException {
        int readHeaderBytes;
        byte[] headerBytes = new byte[1024];
        try {
            readHeaderBytes = input.read(headerBytes);
        }
        catch (IOException e) {
            throw new SerializationException("Could not read additional bytes to parse as serialization version 2 or later. " + e.getMessage(), e);
        }
        String headerStr = new String(headerBytes, 0, readHeaderBytes, StandardCharsets.UTF_8);
        int headerIndex = headerStr.indexOf(JSON_HEADER);
        if (headerIndex < 0) {
            throw new SerializationException(String.format("Could not find %s in the first %d bytes", JSON_HEADER, readHeaderBytes));
        }
        int headerStart = headerStr.indexOf("{", headerIndex);
        if (headerStart < 0) {
            throw new SerializationException(String.format("Could not find '{' starting header object in the first %d bytes.", readHeaderBytes));
        }
        int headerEnd = headerStr.indexOf("}", headerStart);
        if (headerEnd < 0) {
            throw new SerializationException(String.format("Could not find '}' ending header object in the first %d bytes.", readHeaderBytes));
        }
        String headerObjectStr = headerStr.substring(headerStart, headerEnd + 1);
        logger.debug("headerObjectStr={}", (Object)headerObjectStr);
        try {
            TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(this){};
            HashMap header = (HashMap)this.objectMapper.readValue(headerObjectStr, (TypeReference)typeRef);
            if (!header.containsKey(DATA_MODEL_VERSION)) {
                throw new SerializationException("Missing dataModelVersion");
            }
            return Integer.parseInt((String)header.get(DATA_MODEL_VERSION));
        }
        catch (IOException e) {
            throw new SerializationException(String.format("Failed to parse header string '%s' due to %s", headerObjectStr, e), e);
        }
        catch (NumberFormatException e) {
            throw new SerializationException(String.format("Failed to parse version string due to %s", e.getMessage()), e);
        }
    }
}

