/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.http.client;

import java.util.List;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.http.client.ClientHttpRequestFactories;
import org.springframework.boot.autoconfigure.http.client.ClientHttpRequestFactoryBuilderCustomizer;
import org.springframework.boot.autoconfigure.http.client.HttpClientProperties;
import org.springframework.boot.autoconfigure.http.client.NotReactiveWebApplicationCondition;
import org.springframework.boot.autoconfigure.ssl.SslAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.client.ClientHttpRequestFactory;

@AutoConfiguration(after={SslAutoConfiguration.class})
@ConditionalOnClass(value={ClientHttpRequestFactory.class})
@Conditional(value={NotReactiveWebApplicationCondition.class})
@EnableConfigurationProperties(value={HttpClientProperties.class})
public class HttpClientAutoConfiguration
implements BeanClassLoaderAware {
    private final ClientHttpRequestFactories factories;
    private ClassLoader beanClassLoader;

    HttpClientAutoConfiguration(ObjectProvider<SslBundles> sslBundles, HttpClientProperties properties) {
        this.factories = new ClientHttpRequestFactories(sslBundles, properties);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Bean
    @ConditionalOnMissingBean
    ClientHttpRequestFactoryBuilder<?> clientHttpRequestFactoryBuilder(ObjectProvider<ClientHttpRequestFactoryBuilderCustomizer<?>> clientHttpRequestFactoryBuilderCustomizers) {
        ClientHttpRequestFactoryBuilder<?> builder = this.factories.builder(this.beanClassLoader);
        return this.customize(builder, clientHttpRequestFactoryBuilderCustomizers.orderedStream().toList());
    }

    private ClientHttpRequestFactoryBuilder<?> customize(ClientHttpRequestFactoryBuilder<?> builder, List<ClientHttpRequestFactoryBuilderCustomizer<?>> customizers) {
        ClientHttpRequestFactoryBuilder[] builderReference = new ClientHttpRequestFactoryBuilder[]{builder};
        LambdaSafe.callbacks(ClientHttpRequestFactoryBuilderCustomizer.class, customizers, (Object)builderReference[0], (Object[])new Object[0]).invoke(customizer -> {
            builderReference[0] = customizer.customize(builderReference[0]);
        });
        return builderReference[0];
    }

    @Bean
    @ConditionalOnMissingBean
    ClientHttpRequestFactorySettings clientHttpRequestFactorySettings() {
        return this.factories.settings();
    }
}

