/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.client.impl;

import jakarta.ws.rs.client.WebTarget;
import java.io.IOException;
import org.apache.nifi.toolkit.client.InputPortClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.RequestConfig;
import org.apache.nifi.toolkit.client.impl.CRUDJerseyClient;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.entity.PortEntity;

public class JerseyInputPortClient
extends CRUDJerseyClient<PortEntity>
implements InputPortClient {
    public JerseyInputPortClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyInputPortClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(baseTarget.path("/process-groups/{pgId}/input-ports"), baseTarget.path("/input-ports/{id}"), requestConfig, PortEntity.class, "Input Port");
    }

    @Override
    public PortEntity createInputPort(String parentGroupId, PortEntity entity) throws NiFiClientException, IOException {
        return this.createComponent(parentGroupId, entity);
    }

    @Override
    public PortEntity getInputPort(String id) throws NiFiClientException, IOException {
        return (PortEntity)this.getComponent(id);
    }

    @Override
    public PortEntity updateInputPort(PortEntity entity) throws NiFiClientException, IOException {
        return this.updateComponent(entity);
    }

    @Override
    public PortEntity deleteInputPort(PortEntity entity) throws NiFiClientException, IOException {
        return this.deleteComponent(entity);
    }

    @Override
    public PortEntity startInputPort(PortEntity entity) throws NiFiClientException, IOException {
        PortEntity startEntity = this.createStateEntity(entity, "RUNNING");
        return this.updateInputPort(startEntity);
    }

    @Override
    public PortEntity stopInputPort(PortEntity entity) throws NiFiClientException, IOException {
        PortEntity startEntity = this.createStateEntity(entity, "STOPPED");
        return this.updateInputPort(startEntity);
    }

    private PortEntity createStateEntity(PortEntity entity, String state) {
        PortDTO component = new PortDTO();
        component.setId(entity.getComponent().getId());
        component.setParentGroupId(entity.getComponent().getParentGroupId());
        component.setState(state);
        PortEntity stateEntity = new PortEntity();
        stateEntity.setId(entity.getId());
        stateEntity.setRevision(entity.getRevision());
        stateEntity.setComponent(component);
        return stateEntity;
    }
}

