/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.StandardEvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.literals.StringLiteralEvaluator;

public class FindEvaluator
extends BooleanEvaluator {
    private final Evaluator<String> subject;
    private final Evaluator<String> search;
    private final Pattern compiledPattern;

    public FindEvaluator(Evaluator<String> subject, Evaluator<String> search) {
        this.subject = subject;
        this.search = search;
        this.compiledPattern = search instanceof StringLiteralEvaluator ? Pattern.compile(search.evaluate(new StandardEvaluationContext(Collections.emptyMap())).getValue()) : null;
    }

    @Override
    public QueryResult<Boolean> evaluate(EvaluationContext evaluationContext) {
        Pattern pattern;
        String subjectValue = this.subject.evaluate(evaluationContext).getValue();
        if (subjectValue == null) {
            return new BooleanQueryResult(false);
        }
        if (this.compiledPattern == null) {
            String expression = this.search.evaluate(evaluationContext).getValue();
            if (expression == null) {
                return new BooleanQueryResult(false);
            }
            pattern = Pattern.compile(expression);
        } else {
            pattern = this.compiledPattern;
        }
        boolean found = pattern.matcher(subjectValue).find();
        return new BooleanQueryResult(found);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

