/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parameter;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.nifi.parameter.ParameterSensitivity;

public class ParameterGroupConfiguration
implements Comparable<ParameterGroupConfiguration> {
    private final String groupName;
    private final String parameterContextName;
    private final Map<String, ParameterSensitivity> parameterSensitivities;
    private final Boolean isSynchronized;

    public ParameterGroupConfiguration(String groupName, String parameterContextName, Map<String, ParameterSensitivity> parameterSensitivities, Boolean isSynchronized) {
        this.groupName = Objects.requireNonNull(groupName, "Parameter group name is required");
        this.parameterContextName = Optional.ofNullable(parameterContextName).orElse(groupName);
        this.parameterSensitivities = Collections.unmodifiableMap(Objects.requireNonNull(parameterSensitivities, "Parameter sensitivity map is required"));
        this.isSynchronized = isSynchronized;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getParameterContextName() {
        return this.parameterContextName;
    }

    public Map<String, ParameterSensitivity> getParameterSensitivities() {
        return this.parameterSensitivities;
    }

    public Boolean isSynchronized() {
        return this.isSynchronized;
    }

    @Override
    public int compareTo(ParameterGroupConfiguration other) {
        if (other == null) {
            return -1;
        }
        String groupName = this.getGroupName();
        String otherGroupName = other.getGroupName();
        if (groupName == null) {
            return otherGroupName == null ? 0 : -1;
        }
        if (otherGroupName == null) {
            return 1;
        }
        return groupName.compareTo(otherGroupName);
    }
}

