/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.insight;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.insight.Component;
import org.apache.hadoop.ozone.insight.Insight;
import org.apache.hadoop.ozone.insight.InsightPoint;
import org.apache.hadoop.ozone.insight.datanode.DatanodeDispatcherInsight;
import org.apache.hadoop.ozone.insight.datanode.RatisInsight;
import org.apache.hadoop.ozone.insight.om.KeyManagerInsight;
import org.apache.hadoop.ozone.insight.om.OmProtocolInsight;
import org.apache.hadoop.ozone.insight.scm.EventQueueInsight;
import org.apache.hadoop.ozone.insight.scm.NodeManagerInsight;
import org.apache.hadoop.ozone.insight.scm.ReplicaManagerInsight;
import org.apache.hadoop.ozone.insight.scm.ScmProtocolBlockLocationInsight;
import org.apache.hadoop.ozone.insight.scm.ScmProtocolContainerLocationInsight;
import org.apache.hadoop.ozone.insight.scm.ScmProtocolDatanodeInsight;
import org.apache.hadoop.ozone.insight.scm.ScmProtocolSecurityInsight;
import picocli.CommandLine;

public class BaseInsightSubCommand {
    @CommandLine.ParentCommand
    private Insight insightCommand;

    public InsightPoint getInsight(OzoneConfiguration configuration, String selection) {
        Map<String, InsightPoint> insights = this.createInsightPoints(configuration);
        if (!insights.containsKey(selection)) {
            throw new RuntimeException(String.format("No such component; %s. Available components: %s", selection, insights.keySet()));
        }
        return insights.get(selection);
    }

    public String getHost(OzoneConfiguration conf, Component component) {
        if (component.getHostname() != null) {
            return "http://" + component.getHostname() + ":" + component.getPort();
        }
        if (component.getName() == Component.Type.SCM) {
            Optional scmHost = HddsUtils.getHostNameFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.scm.block.client.address", "ozone.scm.client.address"});
            return "http://" + (String)scmHost.get() + ":9876";
        }
        if (component.getName() == Component.Type.OM) {
            Optional omHost = HddsUtils.getHostNameFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.om.address"});
            return "http://" + (String)omHost.get() + ":9874";
        }
        throw new IllegalArgumentException("Component type is not supported: " + (Object)((Object)component.getName()));
    }

    public Map<String, InsightPoint> createInsightPoints(OzoneConfiguration configuration) {
        LinkedHashMap<String, InsightPoint> insights = new LinkedHashMap<String, InsightPoint>();
        insights.put("scm.node-manager", new NodeManagerInsight());
        insights.put("scm.replica-manager", new ReplicaManagerInsight());
        insights.put("scm.event-queue", new EventQueueInsight());
        insights.put("scm.protocol.block-location", new ScmProtocolBlockLocationInsight());
        insights.put("scm.protocol.heartbeat", new ScmProtocolDatanodeInsight());
        insights.put("scm.protocol.container-location", new ScmProtocolContainerLocationInsight());
        insights.put("scm.protocol.security", new ScmProtocolSecurityInsight());
        insights.put("om.key-manager", new KeyManagerInsight());
        insights.put("om.protocol.client", new OmProtocolInsight());
        insights.put("datanode.pipeline", new RatisInsight(configuration));
        insights.put("datanode.dispatcher", new DatanodeDispatcherInsight(configuration));
        return insights;
    }

    public Insight getInsightCommand() {
        return this.insightCommand;
    }
}

