/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.DatanodeVersion;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutVersionManager;
import org.apache.hadoop.hdds.utils.HAUtils;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.HddsVersionInfo;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.LegacyHadoopConfigurationSource;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.container.common.DatanodeLayoutStorage;
import org.apache.hadoop.ozone.freon.DatanodeSimulationState;
import org.apache.hadoop.ozone.freon.Freon;
import org.apache.hadoop.ozone.freon.FreonSubcommand;
import org.apache.hadoop.ozone.protocol.StorageContainerDatanodeProtocol;
import org.apache.hadoop.ozone.protocolPB.ReconDatanodeProtocolPB;
import org.apache.hadoop.ozone.protocolPB.StorageContainerDatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.ozone.protocolPB.StorageContainerDatanodeProtocolPB;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="simulate-datanode", description={"Simulate one or many datanodes and register them to SCM.This is used to stress test SCM handling a massive cluster."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class DatanodeSimulator
implements Callable<Void>,
FreonSubcommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatanodeSimulator.class);
    private Map<InetSocketAddress, StorageContainerDatanodeProtocolClientSideTranslatorPB> scmClients;
    private InetSocketAddress reconAddress;
    private StorageContainerDatanodeProtocolClientSideTranslatorPB reconClient;
    private ConfigurationSource conf;
    private List<DatanodeSimulationState> datanodes;
    private Map<UUID, DatanodeSimulationState> datanodesMap;
    private ScheduledExecutorService heartbeatScheduler;
    private StorageContainerDatanodeProtocolProtos.LayoutVersionProto layoutInfo;
    @CommandLine.ParentCommand
    private Freon freonCommand;
    @CommandLine.Option(names={"-t", "--threads"}, description={"Size of the threadpool running heartbeat."}, defaultValue="10")
    private int threadCount = 10;
    @CommandLine.Option(names={"-n", "--nodes"}, description={"Number of simulated datanode instances."}, defaultValue="1")
    private int datanodesCount = 1;
    @CommandLine.Option(names={"-c", "--containers"}, description={"Number of simulated containers per datanode."}, defaultValue="5")
    private int containers = 1;
    @CommandLine.Option(names={"-r", "--reload"}, description={"Reload the datanodes created by previous simulation run."}, defaultValue="true")
    private boolean reload = true;
    private Random random = new Random();
    private AtomicLong totalHeartbeats = new AtomicLong(0L);
    private AtomicLong totalFCRs = new AtomicLong(0L);
    private AtomicLong totalICRs = new AtomicLong(0L);
    private StorageContainerLocationProtocol scmContainerClient;

    @Override
    public Void call() throws Exception {
        this.init();
        this.loadOrCreateDatanodes();
        int successCount = 0;
        for (DatanodeSimulationState dn : this.datanodes) {
            successCount += this.startDatanode(dn) ? 1 : 0;
        }
        LOGGER.info("{} datanodes have been created and registered to SCM/Recon", (Object)successCount);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.heartbeatScheduler.shutdown();
            try {
                this.heartbeatScheduler.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            IOUtils.closeQuietly(this.scmClients.values());
            IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.reconClient});
            LOGGER.info("Successfully closed all the used resources");
            this.saveDatanodesToFile();
        }));
        this.backgroundStatsReporter();
        LOGGER.info("Start growing containers.");
        try {
            this.growContainers();
        }
        catch (IOException e) {
            LOGGER.error("Error creating containers, exiting.", (Throwable)e);
            throw e;
        }
        LOGGER.info("Finished creating container, transitioning datanodes to readonly");
        this.moveDatanodesToReadonly();
        LOGGER.info("All datanodes have been transitioned to read-only.");
        return null;
    }

    private void moveDatanodesToReadonly() {
        for (DatanodeSimulationState dn : this.datanodes) {
            dn.setReadOnly(true);
            for (String pipeline : dn.getPipelines()) {
                try {
                    this.scmContainerClient.closePipeline(HddsProtos.PipelineID.newBuilder().setId(pipeline).build());
                }
                catch (IOException e) {
                    LOGGER.error("Error closing pipeline {}", (Object)pipeline, (Object)e);
                }
            }
        }
    }

    private void backgroundStatsReporter() {
        long interval = HddsServerUtil.getScmHeartbeatInterval((ConfigurationSource)this.conf);
        AtomicLong lastTotalHeartbeats = new AtomicLong(0L);
        AtomicLong lastTotalFCRs = new AtomicLong(0L);
        AtomicLong lastTotalICRs = new AtomicLong(0L);
        AtomicReference<Instant> lastCheck = new AtomicReference<Instant>(Instant.now());
        this.heartbeatScheduler.scheduleAtFixedRate(() -> {
            long heartbeats = this.totalHeartbeats.get() - lastTotalHeartbeats.get();
            lastTotalHeartbeats.set(this.totalHeartbeats.get());
            long fcrs = this.totalFCRs.get() - lastTotalFCRs.get();
            lastTotalFCRs.set(this.totalFCRs.get());
            long icrs = this.totalICRs.get() - lastTotalICRs.get();
            lastTotalICRs.set(this.totalICRs.get());
            long intervalInSeconds = Instant.now().getEpochSecond() - ((Instant)lastCheck.get()).getEpochSecond();
            lastCheck.set(Instant.now());
            LOGGER.info("Heartbeat status: \nTotal heartbeat in cycle: {} ({} per second) \nTotal incremental reported in cycle: {} ({} per second) \nTotal full reported in cycle: {} ({} per second)", new Object[]{heartbeats, heartbeats / intervalInSeconds, icrs, icrs / intervalInSeconds, fcrs, fcrs / intervalInSeconds});
        }, interval, interval, TimeUnit.MILLISECONDS);
    }

    private void loadOrCreateDatanodes() throws UnknownHostException {
        LinkedList<InetSocketAddress> allEndpoints = new LinkedList<InetSocketAddress>(this.scmClients.keySet());
        allEndpoints.add(this.reconAddress);
        if (this.reload) {
            this.datanodes = this.loadDatanodesFromFile();
            for (DatanodeSimulationState datanode : this.datanodes) {
                datanode.initEndpointsState(allEndpoints);
            }
        } else {
            this.datanodes = new ArrayList<DatanodeSimulationState>(this.datanodesCount);
        }
        long containerReportInterval = this.conf.getTimeDuration("hdds.container.report.interval", "60m", TimeUnit.MILLISECONDS);
        for (int i = this.datanodes.size(); i < this.datanodesCount; ++i) {
            this.datanodes.add(new DatanodeSimulationState(this.randomDatanodeDetails(this.conf), containerReportInterval, allEndpoints, this.containers));
        }
        this.datanodesMap = new HashMap<UUID, DatanodeSimulationState>();
        for (DatanodeSimulationState datanode : this.datanodes) {
            this.datanodesMap.put(datanode.getDatanodeDetails().getUuid(), datanode);
        }
    }

    private void growContainers() throws IOException {
        int totalAssignedContainers = 0;
        for (DatanodeSimulationState datanode : this.datanodes) {
            totalAssignedContainers += datanode.getContainers().size();
        }
        int totalExpectedContainers = this.datanodesCount * this.containers;
        int totalCreatedContainers = 0;
        while (totalAssignedContainers < totalExpectedContainers) {
            ContainerWithPipeline cp = this.scmContainerClient.allocateContainer(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE, "test");
            for (DatanodeDetails datanode : cp.getPipeline().getNodeSet()) {
                if (!this.datanodesMap.containsKey(datanode.getUuid())) continue;
                this.datanodesMap.get(datanode.getUuid()).newContainer(cp.getContainerInfo().getContainerID());
                ++totalAssignedContainers;
            }
            ++totalCreatedContainers;
            this.scmContainerClient.closeContainer(cp.getContainerInfo().getContainerID());
        }
        LOGGER.info("Finish assigning {} containers from {} created containers.", (Object)totalAssignedContainers, (Object)totalCreatedContainers);
    }

    private boolean startDatanode(DatanodeSimulationState dn) throws IOException {
        if (!this.registerDataNode(dn)) {
            LOGGER.info("Failed to register datanode to SCM: {}", (Object)dn.getDatanodeDetails());
            return false;
        }
        long scmHeartbeatInterval = HddsServerUtil.getScmHeartbeatInterval((ConfigurationSource)this.conf);
        this.scmClients.forEach((endpoint, client) -> {
            long initialDelay = RandomUtils.secure().randomLong(0L, scmHeartbeatInterval);
            Runnable runnable = () -> this.heartbeat((InetSocketAddress)endpoint, (StorageContainerDatanodeProtocol)client, dn);
            this.heartbeatScheduler.scheduleAtFixedRate(runnable, initialDelay, scmHeartbeatInterval, TimeUnit.MILLISECONDS);
        });
        long reconHeartbeatInterval = HddsServerUtil.getReconHeartbeatInterval((ConfigurationSource)this.conf);
        long initialDelay = RandomUtils.secure().randomLong(0L, reconHeartbeatInterval);
        Runnable runnable = () -> this.heartbeat(this.reconAddress, (StorageContainerDatanodeProtocol)this.reconClient, dn);
        this.heartbeatScheduler.scheduleAtFixedRate(runnable, initialDelay, reconHeartbeatInterval, TimeUnit.MILLISECONDS);
        LOGGER.info("Successfully registered datanode to SCM: {}", (Object)dn.getDatanodeDetails());
        return true;
    }

    void saveDatanodesToFile() {
        File metaDirPath = ServerUtils.getOzoneMetaDirPath((ConfigurationSource)this.conf);
        File file = new File(metaDirPath, "datanode-simulation.json");
        try {
            JsonUtils.writeToFile(this.datanodes, (File)file);
        }
        catch (IOException e) {
            throw new RuntimeException("Error saving datanodes to file.", e);
        }
        LOGGER.info("{} datanodes has been saved to {}", (Object)this.datanodes.size(), (Object)file.getAbsolutePath());
    }

    List<DatanodeSimulationState> loadDatanodesFromFile() {
        File metaDirPath = ServerUtils.getOzoneMetaDirPath((ConfigurationSource)this.conf);
        File file = new File(metaDirPath, "datanode-simulation.json");
        if (!file.exists()) {
            LOGGER.info("File {} doesn't exists, nothing is loaded", (Object)file.getAbsolutePath());
            return new ArrayList<DatanodeSimulationState>();
        }
        try {
            return JsonUtils.readFromFile((File)file, DatanodeSimulationState.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Error Reading datanodes from file.", e);
        }
    }

    private void heartbeat(InetSocketAddress endpoint, StorageContainerDatanodeProtocol client, DatanodeSimulationState dn) {
        try {
            StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto heartbeat = dn.heartbeatRequest(endpoint, this.layoutInfo);
            StorageContainerDatanodeProtocolProtos.SCMHeartbeatResponseProto response = client.sendHeartbeat(heartbeat);
            dn.ackHeartbeatResponse(response);
            this.totalHeartbeats.incrementAndGet();
            if (heartbeat.hasContainerReport()) {
                this.totalFCRs.incrementAndGet();
            } else {
                this.totalICRs.addAndGet(heartbeat.getIncrementalContainerReportCount());
            }
            if (response.getCommandsList().stream().anyMatch(x -> x.getCommandType() == StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.reregisterCommand)) {
                client.register(dn.getDatanodeDetails().getExtendedProtoBufMessage(), dn.createNodeReport(), dn.createFullContainerReport(), dn.createPipelineReport(), this.layoutInfo);
            }
        }
        catch (Exception e) {
            LOGGER.info("Error sending heartbeat for {}: {}", new Object[]{dn.getDatanodeDetails(), e.getMessage(), e});
        }
    }

    private void init() throws IOException {
        this.conf = this.freonCommand.getOzoneConf();
        Collection addresses = HddsUtils.getSCMAddressForDatanodes((ConfigurationSource)this.conf);
        this.scmClients = new HashMap<InetSocketAddress, StorageContainerDatanodeProtocolClientSideTranslatorPB>(addresses.size());
        for (InetSocketAddress address : addresses) {
            this.scmClients.put(address, this.createScmClient(address));
        }
        this.reconAddress = HddsUtils.getReconAddresses((ConfigurationSource)this.conf);
        this.reconClient = this.createReconClient(this.reconAddress);
        this.heartbeatScheduler = Executors.newScheduledThreadPool(this.threadCount);
        this.scmContainerClient = HAUtils.getScmContainerClient((ConfigurationSource)this.conf);
        this.layoutInfo = this.createLayoutInfo();
    }

    private StorageContainerDatanodeProtocolProtos.LayoutVersionProto createLayoutInfo() throws IOException {
        DatanodeLayoutStorage layoutStorage = new DatanodeLayoutStorage(this.conf, UUID.randomUUID().toString());
        HDDSLayoutVersionManager layoutVersionManager = new HDDSLayoutVersionManager(layoutStorage.getLayoutVersion());
        return StorageContainerDatanodeProtocolProtos.LayoutVersionProto.newBuilder().setMetadataLayoutVersion(layoutVersionManager.getMetadataLayoutVersion()).setSoftwareLayoutVersion(layoutVersionManager.getSoftwareLayoutVersion()).build();
    }

    private DatanodeDetails randomDatanodeDetails(ConfigurationSource config) throws UnknownHostException {
        DatanodeDetails details = DatanodeDetails.newBuilder().setUuid(UUID.randomUUID()).build();
        details.setInitialVersion(DatanodeVersion.CURRENT_VERSION);
        details.setCurrentVersion(DatanodeVersion.CURRENT_VERSION);
        details.setHostName(HddsUtils.getHostName((ConfigurationSource)config));
        details.setIpAddress(this.randomIp());
        details.setStandalonePort(0);
        details.setRatisPort(0);
        details.setRestPort(0);
        details.setVersion(HddsVersionInfo.HDDS_VERSION_INFO.getVersion());
        details.setSetupTime(Time.now());
        details.setRevision(HddsVersionInfo.HDDS_VERSION_INFO.getRevision());
        details.setCurrentVersion(DatanodeVersion.CURRENT_VERSION);
        return details;
    }

    private boolean registerDataNode(DatanodeSimulationState dn) throws IOException {
        StorageContainerDatanodeProtocolProtos.ContainerReportsProto containerReports = StorageContainerDatanodeProtocolProtos.ContainerReportsProto.newBuilder().build();
        StorageContainerDatanodeProtocolProtos.NodeReportProto nodeReport = dn.createNodeReport();
        StorageContainerDatanodeProtocolProtos.PipelineReportsProto pipelineReports = StorageContainerDatanodeProtocolProtos.PipelineReportsProto.newBuilder().build();
        boolean isRegistered = false;
        for (StorageContainerDatanodeProtocol storageContainerDatanodeProtocol : this.scmClients.values()) {
            try {
                StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto response = storageContainerDatanodeProtocol.register(dn.getDatanodeDetails().getExtendedProtoBufMessage(), nodeReport, containerReports, pipelineReports, this.layoutInfo);
                if (response.hasHostname() && response.hasIpAddress()) {
                    dn.getDatanodeDetails().setHostName(response.getHostname());
                    dn.getDatanodeDetails().setIpAddress(response.getIpAddress());
                }
                if (response.hasNetworkName() && response.hasNetworkLocation()) {
                    dn.getDatanodeDetails().setNetworkName(response.getNetworkName());
                    dn.getDatanodeDetails().setNetworkLocation(response.getNetworkLocation());
                }
                isRegistered = isRegistered || response.getErrorCode() == StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto.ErrorCode.success;
            }
            catch (IOException e) {
                LOGGER.error("Error register datanode to SCM", (Throwable)e);
            }
        }
        try {
            this.reconClient.register(dn.getDatanodeDetails().getExtendedProtoBufMessage(), nodeReport, containerReports, pipelineReports, this.layoutInfo);
        }
        catch (IOException e) {
            LOGGER.error("Error register datanode to Recon", (Throwable)e);
        }
        dn.setRegistered(isRegistered);
        return isRegistered;
    }

    private StorageContainerDatanodeProtocolClientSideTranslatorPB createScmClient(InetSocketAddress address) throws IOException {
        Configuration hadoopConfig = LegacyHadoopConfigurationSource.asHadoopConfiguration((ConfigurationSource)this.conf);
        RPC.setProtocolEngine((Configuration)hadoopConfig, StorageContainerDatanodeProtocolPB.class, ProtobufRpcEngine.class);
        long version = RPC.getProtocolVersion(StorageContainerDatanodeProtocolPB.class);
        RetryPolicy retryPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)HddsServerUtil.getScmRpcRetryCount((ConfigurationSource)this.conf), (long)HddsServerUtil.getScmRpcRetryInterval((ConfigurationSource)this.conf), (TimeUnit)TimeUnit.MILLISECONDS);
        StorageContainerDatanodeProtocolPB rpcProxy = (StorageContainerDatanodeProtocolPB)RPC.getProtocolProxy(StorageContainerDatanodeProtocolPB.class, (long)version, (InetSocketAddress)address, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)hadoopConfig, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)hadoopConfig), (int)DatanodeSimulator.getScmRpcTimeOutInMilliseconds(this.conf), (RetryPolicy)retryPolicy).getProxy();
        return new StorageContainerDatanodeProtocolClientSideTranslatorPB(rpcProxy);
    }

    private StorageContainerDatanodeProtocolClientSideTranslatorPB createReconClient(InetSocketAddress address) throws IOException {
        Configuration hadoopConfig = LegacyHadoopConfigurationSource.asHadoopConfiguration((ConfigurationSource)this.conf);
        RPC.setProtocolEngine((Configuration)hadoopConfig, ReconDatanodeProtocolPB.class, ProtobufRpcEngine.class);
        long version = RPC.getProtocolVersion(ReconDatanodeProtocolPB.class);
        RetryPolicy retryPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)HddsServerUtil.getScmRpcRetryCount((ConfigurationSource)this.conf), (long)HddsServerUtil.getScmRpcRetryInterval((ConfigurationSource)this.conf), (TimeUnit)TimeUnit.MILLISECONDS);
        ReconDatanodeProtocolPB rpcProxy = (ReconDatanodeProtocolPB)RPC.getProtocolProxy(ReconDatanodeProtocolPB.class, (long)version, (InetSocketAddress)address, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)hadoopConfig, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)hadoopConfig), (int)DatanodeSimulator.getScmRpcTimeOutInMilliseconds(this.conf), (RetryPolicy)retryPolicy).getProxy();
        return new StorageContainerDatanodeProtocolClientSideTranslatorPB((StorageContainerDatanodeProtocolPB)rpcProxy);
    }

    private String randomIp() {
        return this.random.nextInt(256) + "." + this.random.nextInt(256) + "." + this.random.nextInt(256) + "." + this.random.nextInt(256);
    }

    private static int getScmRpcTimeOutInMilliseconds(ConfigurationSource conf) {
        return (int)conf.getTimeDuration("ozone.scm.heartbeat.rpc-timeout", "5s", TimeUnit.MILLISECONDS);
    }
}

