/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.datanode;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;

public class BasicDatanodeInfo {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Long used = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Long capacity = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Double percentUsed = null;
    private final DatanodeDetails dn;
    private final HddsProtos.NodeOperationalState opState;
    private final HddsProtos.NodeState healthState;

    public BasicDatanodeInfo(DatanodeDetails dnDetails, HddsProtos.NodeOperationalState opState, HddsProtos.NodeState healthState) {
        this.dn = dnDetails;
        this.opState = opState;
        this.healthState = healthState;
    }

    public BasicDatanodeInfo(DatanodeDetails dnDetails, HddsProtos.NodeOperationalState opState, HddsProtos.NodeState healthState, long used, long capacity, double percentUsed) {
        this(dnDetails, opState, healthState);
        this.used = used;
        this.capacity = capacity;
        this.percentUsed = percentUsed;
    }

    @JsonProperty(index=5)
    public String getId() {
        return this.dn.getUuidString();
    }

    @JsonProperty(index=10)
    public String getHostName() {
        return this.dn.getHostName();
    }

    @JsonProperty(index=15)
    public String getIpAddress() {
        return this.dn.getIpAddress();
    }

    @JsonProperty(index=20)
    public List<DatanodeDetails.Port> getPorts() {
        return this.dn.getPorts();
    }

    @JsonProperty(index=25)
    public long getSetupTime() {
        return this.dn.getSetupTime();
    }

    @JsonProperty(index=30)
    public int getCurrentVersion() {
        return this.dn.getCurrentVersion();
    }

    @JsonProperty(index=35)
    public HddsProtos.NodeOperationalState getOpState() {
        return this.opState;
    }

    @JsonProperty(index=40)
    public HddsProtos.NodeOperationalState getPersistedOpState() {
        return this.dn.getPersistedOpState();
    }

    @JsonProperty(index=45)
    public long getPersistedOpStateExpiryEpochSec() {
        return this.dn.getPersistedOpStateExpiryEpochSec();
    }

    @JsonProperty(index=50)
    public HddsProtos.NodeState getHealthState() {
        return this.healthState;
    }

    @JsonProperty(index=55)
    public boolean isDecommissioned() {
        return this.dn.isDecommissioned();
    }

    @JsonProperty(index=60)
    public boolean isMaintenance() {
        return this.dn.isMaintenance();
    }

    @JsonProperty(index=65)
    public int getLevel() {
        return this.dn.getLevel();
    }

    @JsonProperty(index=70)
    public int getCost() {
        return this.dn.getCost();
    }

    @JsonProperty(index=75)
    public int getNumOfLeaves() {
        return this.dn.getNumOfLeaves();
    }

    @JsonProperty(index=80)
    public String getNetworkFullPath() {
        return this.dn.getNetworkFullPath();
    }

    @JsonProperty(index=85)
    public String getNetworkLocation() {
        return this.dn.getNetworkLocation();
    }

    @JsonProperty(index=90)
    public String getNetworkName() {
        return this.dn.getNetworkName();
    }

    @JsonProperty(index=95)
    public Long getUsed() {
        return this.used;
    }

    @JsonProperty(index=100)
    public Long getCapacity() {
        return this.capacity;
    }

    @JsonProperty(index=105)
    public Double getPercentUsed() {
        return this.percentUsed;
    }

    @JsonIgnore
    public DatanodeDetails getDatanodeDetails() {
        return this.dn;
    }
}

