/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.placement.metrics;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.hdds.scm.container.placement.metrics.LongMetric;
import org.apache.hadoop.hdds.server.JsonUtils;

public class ContainerStat {
    @JsonProperty(value="Size")
    private LongMetric size;
    @JsonProperty(value="Used")
    private LongMetric used;
    @JsonProperty(value="KeyCount")
    private LongMetric keyCount;
    @JsonProperty(value="ReadBytes")
    private LongMetric readBytes;
    @JsonProperty(value="WriteBytes")
    private LongMetric writeBytes;
    @JsonProperty(value="ReadCount")
    private LongMetric readCount;
    @JsonProperty(value="WriteCount")
    private LongMetric writeCount;

    public ContainerStat() {
        this(0L, 0L, 0L, 0L, 0L, 0L, 0L);
    }

    public ContainerStat(long size, long used, long keyCount, long readBytes, long writeBytes, long readCount, long writeCount) {
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"Container size cannot be negative.");
        Preconditions.checkArgument((used >= 0L ? 1 : 0) != 0, (Object)"Used space cannot be negative.");
        Preconditions.checkArgument((keyCount >= 0L ? 1 : 0) != 0, (Object)"Key count cannot be negative");
        Preconditions.checkArgument((readBytes >= 0L ? 1 : 0) != 0, (Object)"Read bytes read cannot be negative.");
        Preconditions.checkArgument((readBytes >= 0L ? 1 : 0) != 0, (Object)"Write bytes cannot be negative.");
        Preconditions.checkArgument((readCount >= 0L ? 1 : 0) != 0, (Object)"Read count cannot be negative.");
        Preconditions.checkArgument((writeCount >= 0L ? 1 : 0) != 0, (Object)"Write count cannot be negative");
        this.size = new LongMetric(size);
        this.used = new LongMetric(used);
        this.keyCount = new LongMetric(keyCount);
        this.readBytes = new LongMetric(readBytes);
        this.writeBytes = new LongMetric(writeBytes);
        this.readCount = new LongMetric(readCount);
        this.writeCount = new LongMetric(writeCount);
    }

    public LongMetric getSize() {
        return this.size;
    }

    public LongMetric getUsed() {
        return this.used;
    }

    public LongMetric getKeyCount() {
        return this.keyCount;
    }

    public LongMetric getReadBytes() {
        return this.readBytes;
    }

    public LongMetric getWriteBytes() {
        return this.writeBytes;
    }

    public LongMetric getReadCount() {
        return this.readCount;
    }

    public LongMetric getWriteCount() {
        return this.writeCount;
    }

    public void add(ContainerStat stat) {
        if (stat == null) {
            return;
        }
        this.size.add(stat.getSize().get());
        this.used.add(stat.getUsed().get());
        this.keyCount.add(stat.getKeyCount().get());
        this.readBytes.add(stat.getReadBytes().get());
        this.writeBytes.add(stat.getWriteBytes().get());
        this.readCount.add(stat.getReadCount().get());
        this.writeCount.add(stat.getWriteCount().get());
    }

    public void subtract(ContainerStat stat) {
        if (stat == null) {
            return;
        }
        this.size.subtract(stat.getSize().get());
        this.used.subtract(stat.getUsed().get());
        this.keyCount.subtract(stat.getKeyCount().get());
        this.readBytes.subtract(stat.getReadBytes().get());
        this.writeBytes.subtract(stat.getWriteBytes().get());
        this.readCount.subtract(stat.getReadCount().get());
        this.writeCount.subtract(stat.getWriteCount().get());
    }

    public String toJsonString() {
        try {
            return JsonUtils.toJsonString((Object)this);
        }
        catch (IOException ignored) {
            return null;
        }
    }
}

