/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.replication.CommandTargetOverloadedException;
import org.apache.hadoop.hdds.scm.container.replication.ContainerHealthResult;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaOp;
import org.apache.hadoop.hdds.scm.container.replication.QuasiClosedStuckReplicaCount;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManagerMetrics;
import org.apache.hadoop.hdds.scm.container.replication.UnhealthyReplicationHandler;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuasiClosedStuckOverReplicationHandler
implements UnhealthyReplicationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(QuasiClosedStuckOverReplicationHandler.class);
    private final ReplicationManager replicationManager;
    private final ReplicationManagerMetrics metrics;

    public QuasiClosedStuckOverReplicationHandler(ReplicationManager replicationManager) {
        this.replicationManager = replicationManager;
        this.metrics = replicationManager.getMetrics();
    }

    @Override
    public int processAndSendCommands(Set<ContainerReplica> replicas, List<ContainerReplicaOp> pendingOps, ContainerHealthResult result, int remainingMaintenanceRedundancy) throws IOException {
        ContainerInfo containerInfo = result.getContainerInfo();
        LOG.debug("Handling over replicated QuasiClosed Stuck Ratis container {}", (Object)containerInfo);
        int pendingDelete = 0;
        for (ContainerReplicaOp op : pendingOps) {
            if (op.getOpType() != ContainerReplicaOp.PendingOpType.DELETE) continue;
            ++pendingDelete;
        }
        if (pendingDelete > 0) {
            LOG.debug("Container {} has pending delete operations. No more over replication will be scheduled until they complete", (Object)containerInfo);
            return 0;
        }
        Set<ContainerReplica> healthyReplicas = replicas.stream().filter(replica -> {
            try {
                return this.replicationManager.getNodeStatus(replica.getDatanodeDetails()).getHealth() == HddsProtos.NodeState.HEALTHY;
            }
            catch (NodeNotFoundException e) {
                return false;
            }
        }).collect(Collectors.toSet());
        QuasiClosedStuckReplicaCount replicaCount = new QuasiClosedStuckReplicaCount(healthyReplicas, remainingMaintenanceRedundancy);
        List<QuasiClosedStuckReplicaCount.MisReplicatedOrigin> misReplicatedOrigins = replicaCount.getOverReplicatedOrigins();
        if (misReplicatedOrigins.isEmpty()) {
            LOG.debug("Container {} is not over replicated", (Object)containerInfo);
            return 0;
        }
        int totalCommandsSent = 0;
        CommandTargetOverloadedException firstException = null;
        for (QuasiClosedStuckReplicaCount.MisReplicatedOrigin origin : misReplicatedOrigins) {
            List<ContainerReplica> sortedReplicas = this.getSortedReplicas(origin.getSources());
            for (int i = 0; i < origin.getReplicaDelta(); ++i) {
                try {
                    this.replicationManager.sendThrottledDeleteCommand(containerInfo, 0, sortedReplicas.get(i).getDatanodeDetails(), true);
                    ++totalCommandsSent;
                    continue;
                }
                catch (CommandTargetOverloadedException e) {
                    LOG.debug("Unable to send delete command for container {} to {} as it has too many pending delete commands", (Object)containerInfo, (Object)sortedReplicas.get(i).getDatanodeDetails());
                    firstException = e;
                }
            }
        }
        if (firstException != null) {
            if (totalCommandsSent > 0) {
                this.metrics.incrPartialReplicationTotal();
            }
            throw firstException;
        }
        return totalCommandsSent;
    }

    private List<ContainerReplica> getSortedReplicas(Set<ContainerReplica> replicas) {
        return replicas.stream().sorted(Comparator.comparingLong(ContainerReplica::hashCode)).collect(Collectors.toList());
    }
}

