/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication.health;

import java.util.Set;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ReplicationManagerReport;
import org.apache.hadoop.hdds.scm.container.replication.ContainerCheckRequest;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.container.replication.health.AbstractCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenContainerHandler
extends AbstractCheck {
    private static final Logger LOG = LoggerFactory.getLogger(OpenContainerHandler.class);
    private final ReplicationManager replicationManager;

    public OpenContainerHandler(ReplicationManager replicationManager) {
        this.replicationManager = replicationManager;
    }

    @Override
    public boolean handle(ContainerCheckRequest request) {
        ContainerInfo containerInfo = request.getContainerInfo();
        if (containerInfo.getState() == HddsProtos.LifeCycleState.OPEN) {
            boolean unhealthy;
            LOG.debug("Checking open container {} in OpenContainerHandler", (Object)containerInfo);
            boolean noPipeline = !this.replicationManager.hasHealthyPipeline(containerInfo);
            boolean bl = unhealthy = noPipeline || !this.isOpenContainerHealthy(containerInfo, request.getContainerReplicas());
            if (unhealthy) {
                LOG.info("Container {} is open but {}. Triggering close.", (Object)containerInfo, (Object)(noPipeline ? "has no Pipeline" : "unhealthy"));
                request.getReport().incrementAndSample(noPipeline ? ReplicationManagerReport.HealthState.OPEN_WITHOUT_PIPELINE : ReplicationManagerReport.HealthState.OPEN_UNHEALTHY, containerInfo.containerID());
                if (!request.isReadOnly()) {
                    this.replicationManager.sendCloseContainerEvent(containerInfo.containerID());
                }
            }
            return true;
        }
        return false;
    }

    private boolean isOpenContainerHealthy(ContainerInfo container, Set<ContainerReplica> replicas) {
        HddsProtos.LifeCycleState state = container.getState();
        return replicas.stream().allMatch(r -> ReplicationManager.compareState(state, r.getState()));
    }
}

