/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.snapshot;

import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.CountingPathVisitor;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OMDBCheckpointUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OMDBCheckpointUtils.class);
    private static final PathFilter SST_FILE_FILTER = new SuffixFileFilter(".sst", IOCase.INSENSITIVE);

    private OMDBCheckpointUtils() {
    }

    public static boolean includeSnapshotData(HttpServletRequest request) {
        String includeParam = request.getParameter("includeSnapshotData");
        return Boolean.parseBoolean(includeParam);
    }

    public static void logEstimatedTarballSize(Path dbLocation, Set<Path> snapshotPaths) {
        try {
            Counters.PathCounters counters = Counters.longPathCounters();
            CountingPathVisitor visitor = new CountingPathVisitor(counters, SST_FILE_FILTER, (PathFilter)TrueFileFilter.TRUE);
            Files.walkFileTree(dbLocation, (FileVisitor<? super Path>)visitor);
            boolean includeSnapshotData = !snapshotPaths.isEmpty();
            long totalSnapshots = snapshotPaths.size();
            if (includeSnapshotData) {
                for (Path snapshotDir : snapshotPaths) {
                    Files.walkFileTree(snapshotDir, (FileVisitor<? super Path>)visitor);
                }
            }
            LOG.info("Estimates for Checkpoint Tarball Stream - Data size: {} KB, SST files: {}{}", new Object[]{counters.getByteCounter().get() / 1024L, counters.getFileCounter().get(), includeSnapshotData ? ", snapshots: " + totalSnapshots : ""});
        }
        catch (Exception e) {
            LOG.error("Could not estimate size of transfer to Checkpoint Tarball Stream for dbLocation:{} snapshotPaths:{}", new Object[]{dbLocation, snapshotPaths, e});
        }
    }
}

