/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.scm;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.ozone.recon.scm.ReconNodeManager;
import org.apache.hadoop.ozone.recon.scm.ReconPipelineManager;
import org.apache.hadoop.ozone.recon.scm.ReconScmTask;
import org.apache.hadoop.ozone.recon.spi.StorageContainerServiceProvider;
import org.apache.hadoop.ozone.recon.tasks.ReconTaskConfig;
import org.apache.hadoop.ozone.recon.tasks.updater.ReconTaskStatusUpdater;
import org.apache.hadoop.ozone.recon.tasks.updater.ReconTaskStatusUpdaterManager;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineSyncTask
extends ReconScmTask {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineSyncTask.class);
    private StorageContainerServiceProvider scmClient;
    private ReconPipelineManager reconPipelineManager;
    private ReconNodeManager nodeManager;
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final long interval;
    private final ReconTaskStatusUpdater taskStatusUpdater;

    public PipelineSyncTask(ReconPipelineManager pipelineManager, ReconNodeManager nodeManager, StorageContainerServiceProvider scmClient, ReconTaskConfig reconTaskConfig, ReconTaskStatusUpdaterManager taskStatusUpdaterManager) {
        super(taskStatusUpdaterManager);
        this.scmClient = scmClient;
        this.reconPipelineManager = pipelineManager;
        this.nodeManager = nodeManager;
        this.interval = reconTaskConfig.getPipelineSyncTaskInterval().toMillis();
        this.taskStatusUpdater = this.getTaskStatusUpdater();
    }

    @Override
    public void run() {
        try {
            while (this.canRun()) {
                this.initializeAndRunTask();
                Thread.sleep(this.interval);
            }
        }
        catch (Throwable t) {
            LOG.error("Exception in Pipeline sync Thread.", t);
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.taskStatusUpdater.setLastTaskRunStatus(-1);
            this.taskStatusUpdater.recordRunCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runTask() throws IOException, NodeNotFoundException {
        this.lock.writeLock().lock();
        try {
            long start = Time.monotonicNow();
            List<Pipeline> pipelinesFromScm = this.scmClient.getPipelines();
            this.reconPipelineManager.initializePipelines(pipelinesFromScm);
            this.syncOperationalStateOnDeadNodes();
            LOG.debug("Pipeline sync Thread took {} milliseconds.", (Object)(Time.monotonicNow() - start));
            this.taskStatusUpdater.setLastTaskRunStatus(0);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void syncOperationalStateOnDeadNodes() throws IOException, NodeNotFoundException {
        List deadNodesOnRecon = this.nodeManager.getNodes(null, HddsProtos.NodeState.DEAD);
        if (!deadNodesOnRecon.isEmpty()) {
            List<HddsProtos.Node> scmNodes = this.scmClient.getNodes();
            List filteredScmNodes = scmNodes.stream().filter(n -> deadNodesOnRecon.contains(DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)n.getNodeID()))).collect(Collectors.toList());
            for (HddsProtos.Node deadNode : filteredScmNodes) {
                DatanodeDetails dnDetails = DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)deadNode.getNodeID());
                HddsProtos.NodeState scmNodeState = deadNode.getNodeStates(0);
                if (scmNodeState != HddsProtos.NodeState.DEAD) {
                    LOG.warn("Node {} DEAD in Recon, but SCM reports it as {}", (Object)dnDetails.getHostName(), (Object)scmNodeState);
                }
                this.nodeManager.updateNodeOperationalStateFromScm(deadNode, dnDetails);
            }
        }
    }
}

